/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.CompositeSlotTypeSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.ExternalSourceSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValuesCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotValueSelectionSetting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSlotTypeResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, CreateSlotTypeResponse> {
    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotTypeId").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::slotTypeId)).setter(CreateSlotTypeResponse.setter(Builder::slotTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()}).build();
    private static final SdkField<String> SLOT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotTypeName").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::slotTypeName)).setter(CreateSlotTypeResponse.setter(Builder::slotTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::description)).setter(CreateSlotTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<SlotTypeValue>> SLOT_TYPE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slotTypeValues").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::slotTypeValues)).setter(CreateSlotTypeResponse.setter(Builder::slotTypeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlotTypeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SlotValueSelectionSetting> VALUE_SELECTION_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("valueSelectionSetting").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::valueSelectionSetting)).setter(CreateSlotTypeResponse.setter(Builder::valueSelectionSetting)).constructor(SlotValueSelectionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionSetting").build()}).build();
    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentSlotTypeSignature").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::parentSlotTypeSignature)).setter(CreateSlotTypeResponse.setter(Builder::parentSlotTypeSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::botId)).setter(CreateSlotTypeResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::botVersion)).setter(CreateSlotTypeResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::localeId)).setter(CreateSlotTypeResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::creationDateTime)).setter(CreateSlotTypeResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<ExternalSourceSetting> EXTERNAL_SOURCE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalSourceSetting").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::externalSourceSetting)).setter(CreateSlotTypeResponse.setter(Builder::externalSourceSetting)).constructor(ExternalSourceSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalSourceSetting").build()}).build();
    private static final SdkField<CompositeSlotTypeSetting> COMPOSITE_SLOT_TYPE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("compositeSlotTypeSetting").getter(CreateSlotTypeResponse.getter(CreateSlotTypeResponse::compositeSlotTypeSetting)).setter(CreateSlotTypeResponse.setter(Builder::compositeSlotTypeSetting)).constructor(CompositeSlotTypeSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeSlotTypeSetting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_ID_FIELD, SLOT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, SLOT_TYPE_VALUES_FIELD, VALUE_SELECTION_SETTING_FIELD, PARENT_SLOT_TYPE_SIGNATURE_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, CREATION_DATE_TIME_FIELD, EXTERNAL_SOURCE_SETTING_FIELD, COMPOSITE_SLOT_TYPE_SETTING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSlotTypeResponse.memberNameToFieldInitializer();
    private final String slotTypeId;
    private final String slotTypeName;
    private final String description;
    private final List<SlotTypeValue> slotTypeValues;
    private final SlotValueSelectionSetting valueSelectionSetting;
    private final String parentSlotTypeSignature;
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final Instant creationDateTime;
    private final ExternalSourceSetting externalSourceSetting;
    private final CompositeSlotTypeSetting compositeSlotTypeSetting;

    private CreateSlotTypeResponse(BuilderImpl builder) {
        super(builder);
        this.slotTypeId = builder.slotTypeId;
        this.slotTypeName = builder.slotTypeName;
        this.description = builder.description;
        this.slotTypeValues = builder.slotTypeValues;
        this.valueSelectionSetting = builder.valueSelectionSetting;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.creationDateTime = builder.creationDateTime;
        this.externalSourceSetting = builder.externalSourceSetting;
        this.compositeSlotTypeSetting = builder.compositeSlotTypeSetting;
    }

    public final String slotTypeId() {
        return this.slotTypeId;
    }

    public final String slotTypeName() {
        return this.slotTypeName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSlotTypeValues() {
        return this.slotTypeValues != null && !(this.slotTypeValues instanceof SdkAutoConstructList);
    }

    public final List<SlotTypeValue> slotTypeValues() {
        return this.slotTypeValues;
    }

    public final SlotValueSelectionSetting valueSelectionSetting() {
        return this.valueSelectionSetting;
    }

    public final String parentSlotTypeSignature() {
        return this.parentSlotTypeSignature;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final ExternalSourceSetting externalSourceSetting() {
        return this.externalSourceSetting;
    }

    public final CompositeSlotTypeSetting compositeSlotTypeSetting() {
        return this.compositeSlotTypeSetting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlotTypeValues() ? this.slotTypeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.valueSelectionSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalSourceSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.compositeSlotTypeSetting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSlotTypeResponse)) {
            return false;
        }
        CreateSlotTypeResponse other = (CreateSlotTypeResponse)((Object)obj);
        return Objects.equals(this.slotTypeId(), other.slotTypeId()) && Objects.equals(this.slotTypeName(), other.slotTypeName()) && Objects.equals(this.description(), other.description()) && this.hasSlotTypeValues() == other.hasSlotTypeValues() && Objects.equals(this.slotTypeValues(), other.slotTypeValues()) && Objects.equals(this.valueSelectionSetting(), other.valueSelectionSetting()) && Objects.equals(this.parentSlotTypeSignature(), other.parentSlotTypeSignature()) && Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.externalSourceSetting(), other.externalSourceSetting()) && Objects.equals(this.compositeSlotTypeSetting(), other.compositeSlotTypeSetting());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSlotTypeResponse").add("SlotTypeId", (Object)this.slotTypeId()).add("SlotTypeName", (Object)this.slotTypeName()).add("Description", (Object)this.description()).add("SlotTypeValues", this.hasSlotTypeValues() ? this.slotTypeValues() : null).add("ValueSelectionSetting", (Object)this.valueSelectionSetting()).add("ParentSlotTypeSignature", (Object)this.parentSlotTypeSignature()).add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("CreationDateTime", (Object)this.creationDateTime()).add("ExternalSourceSetting", (Object)this.externalSourceSetting()).add("CompositeSlotTypeSetting", (Object)this.compositeSlotTypeSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "slotTypeId": {
                return Optional.ofNullable(clazz.cast(this.slotTypeId()));
            }
            case "slotTypeName": {
                return Optional.ofNullable(clazz.cast(this.slotTypeName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "slotTypeValues": {
                return Optional.ofNullable(clazz.cast(this.slotTypeValues()));
            }
            case "valueSelectionSetting": {
                return Optional.ofNullable(clazz.cast(this.valueSelectionSetting()));
            }
            case "parentSlotTypeSignature": {
                return Optional.ofNullable(clazz.cast(this.parentSlotTypeSignature()));
            }
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "externalSourceSetting": {
                return Optional.ofNullable(clazz.cast(this.externalSourceSetting()));
            }
            case "compositeSlotTypeSetting": {
                return Optional.ofNullable(clazz.cast(this.compositeSlotTypeSetting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("slotTypeId", SLOT_TYPE_ID_FIELD);
        map.put("slotTypeName", SLOT_TYPE_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("slotTypeValues", SLOT_TYPE_VALUES_FIELD);
        map.put("valueSelectionSetting", VALUE_SELECTION_SETTING_FIELD);
        map.put("parentSlotTypeSignature", PARENT_SLOT_TYPE_SIGNATURE_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("externalSourceSetting", EXTERNAL_SOURCE_SETTING_FIELD);
        map.put("compositeSlotTypeSetting", COMPOSITE_SLOT_TYPE_SETTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSlotTypeResponse, T> g) {
        return obj -> g.apply((CreateSlotTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String slotTypeId;
        private String slotTypeName;
        private String description;
        private List<SlotTypeValue> slotTypeValues = DefaultSdkAutoConstructList.getInstance();
        private SlotValueSelectionSetting valueSelectionSetting;
        private String parentSlotTypeSignature;
        private String botId;
        private String botVersion;
        private String localeId;
        private Instant creationDateTime;
        private ExternalSourceSetting externalSourceSetting;
        private CompositeSlotTypeSetting compositeSlotTypeSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSlotTypeResponse model) {
            super(model);
            this.slotTypeId(model.slotTypeId);
            this.slotTypeName(model.slotTypeName);
            this.description(model.description);
            this.slotTypeValues(model.slotTypeValues);
            this.valueSelectionSetting(model.valueSelectionSetting);
            this.parentSlotTypeSignature(model.parentSlotTypeSignature);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.creationDateTime(model.creationDateTime);
            this.externalSourceSetting(model.externalSourceSetting);
            this.compositeSlotTypeSetting(model.compositeSlotTypeSetting);
        }

        public final String getSlotTypeId() {
            return this.slotTypeId;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final String getSlotTypeName() {
            return this.slotTypeName;
        }

        public final void setSlotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
        }

        @Override
        public final Builder slotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SlotTypeValue.Builder> getSlotTypeValues() {
            List<SlotTypeValue.Builder> result = SlotTypeValuesCopier.copyToBuilder(this.slotTypeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotTypeValues(Collection<SlotTypeValue.BuilderImpl> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copyFromBuilder(slotTypeValues);
        }

        @Override
        public final Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copy(slotTypeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeValues(SlotTypeValue ... slotTypeValues) {
            this.slotTypeValues(Arrays.asList(slotTypeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeValues(Consumer<SlotTypeValue.Builder> ... slotTypeValues) {
            this.slotTypeValues(Stream.of(slotTypeValues).map(c -> (SlotTypeValue)((SlotTypeValue.Builder)SlotTypeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SlotValueSelectionSetting.Builder getValueSelectionSetting() {
            return this.valueSelectionSetting != null ? this.valueSelectionSetting.toBuilder() : null;
        }

        public final void setValueSelectionSetting(SlotValueSelectionSetting.BuilderImpl valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting != null ? valueSelectionSetting.build() : null;
        }

        @Override
        public final Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting;
            return this;
        }

        public final String getParentSlotTypeSignature() {
            return this.parentSlotTypeSignature;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final ExternalSourceSetting.Builder getExternalSourceSetting() {
            return this.externalSourceSetting != null ? this.externalSourceSetting.toBuilder() : null;
        }

        public final void setExternalSourceSetting(ExternalSourceSetting.BuilderImpl externalSourceSetting) {
            this.externalSourceSetting = externalSourceSetting != null ? externalSourceSetting.build() : null;
        }

        @Override
        public final Builder externalSourceSetting(ExternalSourceSetting externalSourceSetting) {
            this.externalSourceSetting = externalSourceSetting;
            return this;
        }

        public final CompositeSlotTypeSetting.Builder getCompositeSlotTypeSetting() {
            return this.compositeSlotTypeSetting != null ? this.compositeSlotTypeSetting.toBuilder() : null;
        }

        public final void setCompositeSlotTypeSetting(CompositeSlotTypeSetting.BuilderImpl compositeSlotTypeSetting) {
            this.compositeSlotTypeSetting = compositeSlotTypeSetting != null ? compositeSlotTypeSetting.build() : null;
        }

        @Override
        public final Builder compositeSlotTypeSetting(CompositeSlotTypeSetting compositeSlotTypeSetting) {
            this.compositeSlotTypeSetting = compositeSlotTypeSetting;
            return this;
        }

        @Override
        public CreateSlotTypeResponse build() {
            return new CreateSlotTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSlotTypeResponse> {
        public Builder slotTypeId(String var1);

        public Builder slotTypeName(String var1);

        public Builder description(String var1);

        public Builder slotTypeValues(Collection<SlotTypeValue> var1);

        public Builder slotTypeValues(SlotTypeValue ... var1);

        public Builder slotTypeValues(Consumer<SlotTypeValue.Builder> ... var1);

        public Builder valueSelectionSetting(SlotValueSelectionSetting var1);

        default public Builder valueSelectionSetting(Consumer<SlotValueSelectionSetting.Builder> valueSelectionSetting) {
            return this.valueSelectionSetting((SlotValueSelectionSetting)((SlotValueSelectionSetting.Builder)SlotValueSelectionSetting.builder().applyMutation(valueSelectionSetting)).build());
        }

        public Builder parentSlotTypeSignature(String var1);

        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder externalSourceSetting(ExternalSourceSetting var1);

        default public Builder externalSourceSetting(Consumer<ExternalSourceSetting.Builder> externalSourceSetting) {
            return this.externalSourceSetting((ExternalSourceSetting)((ExternalSourceSetting.Builder)ExternalSourceSetting.builder().applyMutation(externalSourceSetting)).build());
        }

        public Builder compositeSlotTypeSetting(CompositeSlotTypeSetting var1);

        default public Builder compositeSlotTypeSetting(Consumer<CompositeSlotTypeSetting.Builder> compositeSlotTypeSetting) {
            return this.compositeSlotTypeSetting((CompositeSlotTypeSetting)((CompositeSlotTypeSetting.Builder)CompositeSlotTypeSetting.builder().applyMutation(compositeSlotTypeSetting)).build());
        }
    }
}

