/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.DialogCodeHookSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.InitialResponseSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.InputContext;
import software.amazon.awssdk.services.lexmodelsv2.model.InputContextsListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.KendraConfiguration;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.OutputContext;
import software.amazon.awssdk.services.lexmodelsv2.model.OutputContextsListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.QnAIntentConfiguration;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterancesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIntentRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, CreateIntentRequest> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(CreateIntentRequest.getter(CreateIntentRequest::intentName)).setter(CreateIntentRequest.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateIntentRequest.getter(CreateIntentRequest::description)).setter(CreateIntentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentIntentSignature").getter(CreateIntentRequest.getter(CreateIntentRequest::parentIntentSignature)).setter(CreateIntentRequest.setter(Builder::parentIntentSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build()}).build();
    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sampleUtterances").getter(CreateIntentRequest.getter(CreateIntentRequest::sampleUtterances)).setter(CreateIntentRequest.setter(Builder::sampleUtterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SampleUtterance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DialogCodeHookSettings> DIALOG_CODE_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dialogCodeHook").getter(CreateIntentRequest.getter(CreateIntentRequest::dialogCodeHook)).setter(CreateIntentRequest.setter(Builder::dialogCodeHook)).constructor(DialogCodeHookSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()}).build();
    private static final SdkField<FulfillmentCodeHookSettings> FULFILLMENT_CODE_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fulfillmentCodeHook").getter(CreateIntentRequest.getter(CreateIntentRequest::fulfillmentCodeHook)).setter(CreateIntentRequest.setter(Builder::fulfillmentCodeHook)).constructor(FulfillmentCodeHookSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentCodeHook").build()}).build();
    private static final SdkField<IntentConfirmationSetting> INTENT_CONFIRMATION_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intentConfirmationSetting").getter(CreateIntentRequest.getter(CreateIntentRequest::intentConfirmationSetting)).setter(CreateIntentRequest.setter(Builder::intentConfirmationSetting)).constructor(IntentConfirmationSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentConfirmationSetting").build()}).build();
    private static final SdkField<IntentClosingSetting> INTENT_CLOSING_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intentClosingSetting").getter(CreateIntentRequest.getter(CreateIntentRequest::intentClosingSetting)).setter(CreateIntentRequest.setter(Builder::intentClosingSetting)).constructor(IntentClosingSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClosingSetting").build()}).build();
    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputContexts").getter(CreateIntentRequest.getter(CreateIntentRequest::inputContexts)).setter(CreateIntentRequest.setter(Builder::inputContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputContexts").getter(CreateIntentRequest.getter(CreateIntentRequest::outputContexts)).setter(CreateIntentRequest.setter(Builder::outputContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kendraConfiguration").getter(CreateIntentRequest.getter(CreateIntentRequest::kendraConfiguration)).setter(CreateIntentRequest.setter(Builder::kendraConfiguration)).constructor(KendraConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(CreateIntentRequest.getter(CreateIntentRequest::botId)).setter(CreateIntentRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(CreateIntentRequest.getter(CreateIntentRequest::botVersion)).setter(CreateIntentRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(CreateIntentRequest.getter(CreateIntentRequest::localeId)).setter(CreateIntentRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<InitialResponseSetting> INITIAL_RESPONSE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("initialResponseSetting").getter(CreateIntentRequest.getter(CreateIntentRequest::initialResponseSetting)).setter(CreateIntentRequest.setter(Builder::initialResponseSetting)).constructor(InitialResponseSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialResponseSetting").build()}).build();
    private static final SdkField<QnAIntentConfiguration> QN_A_INTENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qnAIntentConfiguration").getter(CreateIntentRequest.getter(CreateIntentRequest::qnAIntentConfiguration)).setter(CreateIntentRequest.setter(Builder::qnAIntentConfiguration)).constructor(QnAIntentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qnAIntentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD, DESCRIPTION_FIELD, PARENT_INTENT_SIGNATURE_FIELD, SAMPLE_UTTERANCES_FIELD, DIALOG_CODE_HOOK_FIELD, FULFILLMENT_CODE_HOOK_FIELD, INTENT_CONFIRMATION_SETTING_FIELD, INTENT_CLOSING_SETTING_FIELD, INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD, KENDRA_CONFIGURATION_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, INITIAL_RESPONSE_SETTING_FIELD, QN_A_INTENT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIntentRequest.memberNameToFieldInitializer();
    private final String intentName;
    private final String description;
    private final String parentIntentSignature;
    private final List<SampleUtterance> sampleUtterances;
    private final DialogCodeHookSettings dialogCodeHook;
    private final FulfillmentCodeHookSettings fulfillmentCodeHook;
    private final IntentConfirmationSetting intentConfirmationSetting;
    private final IntentClosingSetting intentClosingSetting;
    private final List<InputContext> inputContexts;
    private final List<OutputContext> outputContexts;
    private final KendraConfiguration kendraConfiguration;
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final InitialResponseSetting initialResponseSetting;
    private final QnAIntentConfiguration qnAIntentConfiguration;

    private CreateIntentRequest(BuilderImpl builder) {
        super(builder);
        this.intentName = builder.intentName;
        this.description = builder.description;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.sampleUtterances = builder.sampleUtterances;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentCodeHook = builder.fulfillmentCodeHook;
        this.intentConfirmationSetting = builder.intentConfirmationSetting;
        this.intentClosingSetting = builder.intentClosingSetting;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.initialResponseSetting = builder.initialResponseSetting;
        this.qnAIntentConfiguration = builder.qnAIntentConfiguration;
    }

    public final String intentName() {
        return this.intentName;
    }

    public final String description() {
        return this.description;
    }

    public final String parentIntentSignature() {
        return this.parentIntentSignature;
    }

    public final boolean hasSampleUtterances() {
        return this.sampleUtterances != null && !(this.sampleUtterances instanceof SdkAutoConstructList);
    }

    public final List<SampleUtterance> sampleUtterances() {
        return this.sampleUtterances;
    }

    public final DialogCodeHookSettings dialogCodeHook() {
        return this.dialogCodeHook;
    }

    public final FulfillmentCodeHookSettings fulfillmentCodeHook() {
        return this.fulfillmentCodeHook;
    }

    public final IntentConfirmationSetting intentConfirmationSetting() {
        return this.intentConfirmationSetting;
    }

    public final IntentClosingSetting intentClosingSetting() {
        return this.intentClosingSetting;
    }

    public final boolean hasInputContexts() {
        return this.inputContexts != null && !(this.inputContexts instanceof SdkAutoConstructList);
    }

    public final List<InputContext> inputContexts() {
        return this.inputContexts;
    }

    public final boolean hasOutputContexts() {
        return this.outputContexts != null && !(this.outputContexts instanceof SdkAutoConstructList);
    }

    public final List<OutputContext> outputContexts() {
        return this.outputContexts;
    }

    public final KendraConfiguration kendraConfiguration() {
        return this.kendraConfiguration;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final InitialResponseSetting initialResponseSetting() {
        return this.initialResponseSetting;
    }

    public final QnAIntentConfiguration qnAIntentConfiguration() {
        return this.qnAIntentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleUtterances() ? this.sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentConfirmationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentClosingSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputContexts() ? this.inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputContexts() ? this.outputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialResponseSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.qnAIntentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntentRequest)) {
            return false;
        }
        CreateIntentRequest other = (CreateIntentRequest)((Object)obj);
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parentIntentSignature(), other.parentIntentSignature()) && this.hasSampleUtterances() == other.hasSampleUtterances() && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.dialogCodeHook(), other.dialogCodeHook()) && Objects.equals(this.fulfillmentCodeHook(), other.fulfillmentCodeHook()) && Objects.equals(this.intentConfirmationSetting(), other.intentConfirmationSetting()) && Objects.equals(this.intentClosingSetting(), other.intentClosingSetting()) && this.hasInputContexts() == other.hasInputContexts() && Objects.equals(this.inputContexts(), other.inputContexts()) && this.hasOutputContexts() == other.hasOutputContexts() && Objects.equals(this.outputContexts(), other.outputContexts()) && Objects.equals(this.kendraConfiguration(), other.kendraConfiguration()) && Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.initialResponseSetting(), other.initialResponseSetting()) && Objects.equals(this.qnAIntentConfiguration(), other.qnAIntentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIntentRequest").add("IntentName", (Object)this.intentName()).add("Description", (Object)this.description()).add("ParentIntentSignature", (Object)this.parentIntentSignature()).add("SampleUtterances", this.hasSampleUtterances() ? this.sampleUtterances() : null).add("DialogCodeHook", (Object)this.dialogCodeHook()).add("FulfillmentCodeHook", (Object)this.fulfillmentCodeHook()).add("IntentConfirmationSetting", (Object)this.intentConfirmationSetting()).add("IntentClosingSetting", (Object)this.intentClosingSetting()).add("InputContexts", this.hasInputContexts() ? this.inputContexts() : null).add("OutputContexts", this.hasOutputContexts() ? this.outputContexts() : null).add("KendraConfiguration", (Object)this.kendraConfiguration()).add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("InitialResponseSetting", (Object)this.initialResponseSetting()).add("QnAIntentConfiguration", (Object)this.qnAIntentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "parentIntentSignature": {
                return Optional.ofNullable(clazz.cast(this.parentIntentSignature()));
            }
            case "sampleUtterances": {
                return Optional.ofNullable(clazz.cast(this.sampleUtterances()));
            }
            case "dialogCodeHook": {
                return Optional.ofNullable(clazz.cast(this.dialogCodeHook()));
            }
            case "fulfillmentCodeHook": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentCodeHook()));
            }
            case "intentConfirmationSetting": {
                return Optional.ofNullable(clazz.cast(this.intentConfirmationSetting()));
            }
            case "intentClosingSetting": {
                return Optional.ofNullable(clazz.cast(this.intentClosingSetting()));
            }
            case "inputContexts": {
                return Optional.ofNullable(clazz.cast(this.inputContexts()));
            }
            case "outputContexts": {
                return Optional.ofNullable(clazz.cast(this.outputContexts()));
            }
            case "kendraConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kendraConfiguration()));
            }
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "initialResponseSetting": {
                return Optional.ofNullable(clazz.cast(this.initialResponseSetting()));
            }
            case "qnAIntentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.qnAIntentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("intentName", INTENT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("parentIntentSignature", PARENT_INTENT_SIGNATURE_FIELD);
        map.put("sampleUtterances", SAMPLE_UTTERANCES_FIELD);
        map.put("dialogCodeHook", DIALOG_CODE_HOOK_FIELD);
        map.put("fulfillmentCodeHook", FULFILLMENT_CODE_HOOK_FIELD);
        map.put("intentConfirmationSetting", INTENT_CONFIRMATION_SETTING_FIELD);
        map.put("intentClosingSetting", INTENT_CLOSING_SETTING_FIELD);
        map.put("inputContexts", INPUT_CONTEXTS_FIELD);
        map.put("outputContexts", OUTPUT_CONTEXTS_FIELD);
        map.put("kendraConfiguration", KENDRA_CONFIGURATION_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("initialResponseSetting", INITIAL_RESPONSE_SETTING_FIELD);
        map.put("qnAIntentConfiguration", QN_A_INTENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntentRequest, T> g) {
        return obj -> g.apply((CreateIntentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String intentName;
        private String description;
        private String parentIntentSignature;
        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();
        private DialogCodeHookSettings dialogCodeHook;
        private FulfillmentCodeHookSettings fulfillmentCodeHook;
        private IntentConfirmationSetting intentConfirmationSetting;
        private IntentClosingSetting intentClosingSetting;
        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();
        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();
        private KendraConfiguration kendraConfiguration;
        private String botId;
        private String botVersion;
        private String localeId;
        private InitialResponseSetting initialResponseSetting;
        private QnAIntentConfiguration qnAIntentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntentRequest model) {
            super(model);
            this.intentName(model.intentName);
            this.description(model.description);
            this.parentIntentSignature(model.parentIntentSignature);
            this.sampleUtterances(model.sampleUtterances);
            this.dialogCodeHook(model.dialogCodeHook);
            this.fulfillmentCodeHook(model.fulfillmentCodeHook);
            this.intentConfirmationSetting(model.intentConfirmationSetting);
            this.intentClosingSetting(model.intentClosingSetting);
            this.inputContexts(model.inputContexts);
            this.outputContexts(model.outputContexts);
            this.kendraConfiguration(model.kendraConfiguration);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.initialResponseSetting(model.initialResponseSetting);
            this.qnAIntentConfiguration(model.qnAIntentConfiguration);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentIntentSignature() {
            return this.parentIntentSignature;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder> ... sampleUtterances) {
            this.sampleUtterances(Stream.of(sampleUtterances).map(c -> (SampleUtterance)((SampleUtterance.Builder)SampleUtterance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DialogCodeHookSettings.Builder getDialogCodeHook() {
            return this.dialogCodeHook != null ? this.dialogCodeHook.toBuilder() : null;
        }

        public final void setDialogCodeHook(DialogCodeHookSettings.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        @Override
        public final Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final FulfillmentCodeHookSettings.Builder getFulfillmentCodeHook() {
            return this.fulfillmentCodeHook != null ? this.fulfillmentCodeHook.toBuilder() : null;
        }

        public final void setFulfillmentCodeHook(FulfillmentCodeHookSettings.BuilderImpl fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook != null ? fulfillmentCodeHook.build() : null;
        }

        @Override
        public final Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook;
            return this;
        }

        public final IntentConfirmationSetting.Builder getIntentConfirmationSetting() {
            return this.intentConfirmationSetting != null ? this.intentConfirmationSetting.toBuilder() : null;
        }

        public final void setIntentConfirmationSetting(IntentConfirmationSetting.BuilderImpl intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting != null ? intentConfirmationSetting.build() : null;
        }

        @Override
        public final Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting;
            return this;
        }

        public final IntentClosingSetting.Builder getIntentClosingSetting() {
            return this.intentClosingSetting != null ? this.intentClosingSetting.toBuilder() : null;
        }

        public final void setIntentClosingSetting(IntentClosingSetting.BuilderImpl intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting != null ? intentClosingSetting.build() : null;
        }

        @Override
        public final Builder intentClosingSetting(IntentClosingSetting intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting;
            return this;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextsListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextsListCopier.copyFromBuilder(inputContexts);
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextsListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext ... inputContexts) {
            this.inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder> ... inputContexts) {
            this.inputContexts(Stream.of(inputContexts).map(c -> (InputContext)((InputContext.Builder)InputContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextsListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext ... outputContexts) {
            this.outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder> ... outputContexts) {
            this.outputContexts(Stream.of(outputContexts).map(c -> (OutputContext)((OutputContext.Builder)OutputContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return this.kendraConfiguration != null ? this.kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final InitialResponseSetting.Builder getInitialResponseSetting() {
            return this.initialResponseSetting != null ? this.initialResponseSetting.toBuilder() : null;
        }

        public final void setInitialResponseSetting(InitialResponseSetting.BuilderImpl initialResponseSetting) {
            this.initialResponseSetting = initialResponseSetting != null ? initialResponseSetting.build() : null;
        }

        @Override
        public final Builder initialResponseSetting(InitialResponseSetting initialResponseSetting) {
            this.initialResponseSetting = initialResponseSetting;
            return this;
        }

        public final QnAIntentConfiguration.Builder getQnAIntentConfiguration() {
            return this.qnAIntentConfiguration != null ? this.qnAIntentConfiguration.toBuilder() : null;
        }

        public final void setQnAIntentConfiguration(QnAIntentConfiguration.BuilderImpl qnAIntentConfiguration) {
            this.qnAIntentConfiguration = qnAIntentConfiguration != null ? qnAIntentConfiguration.build() : null;
        }

        @Override
        public final Builder qnAIntentConfiguration(QnAIntentConfiguration qnAIntentConfiguration) {
            this.qnAIntentConfiguration = qnAIntentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntentRequest build() {
            return new CreateIntentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIntentRequest> {
        public Builder intentName(String var1);

        public Builder description(String var1);

        public Builder parentIntentSignature(String var1);

        public Builder sampleUtterances(Collection<SampleUtterance> var1);

        public Builder sampleUtterances(SampleUtterance ... var1);

        public Builder sampleUtterances(Consumer<SampleUtterance.Builder> ... var1);

        public Builder dialogCodeHook(DialogCodeHookSettings var1);

        default public Builder dialogCodeHook(Consumer<DialogCodeHookSettings.Builder> dialogCodeHook) {
            return this.dialogCodeHook((DialogCodeHookSettings)((DialogCodeHookSettings.Builder)DialogCodeHookSettings.builder().applyMutation(dialogCodeHook)).build());
        }

        public Builder fulfillmentCodeHook(FulfillmentCodeHookSettings var1);

        default public Builder fulfillmentCodeHook(Consumer<FulfillmentCodeHookSettings.Builder> fulfillmentCodeHook) {
            return this.fulfillmentCodeHook((FulfillmentCodeHookSettings)((FulfillmentCodeHookSettings.Builder)FulfillmentCodeHookSettings.builder().applyMutation(fulfillmentCodeHook)).build());
        }

        public Builder intentConfirmationSetting(IntentConfirmationSetting var1);

        default public Builder intentConfirmationSetting(Consumer<IntentConfirmationSetting.Builder> intentConfirmationSetting) {
            return this.intentConfirmationSetting((IntentConfirmationSetting)((IntentConfirmationSetting.Builder)IntentConfirmationSetting.builder().applyMutation(intentConfirmationSetting)).build());
        }

        public Builder intentClosingSetting(IntentClosingSetting var1);

        default public Builder intentClosingSetting(Consumer<IntentClosingSetting.Builder> intentClosingSetting) {
            return this.intentClosingSetting((IntentClosingSetting)((IntentClosingSetting.Builder)IntentClosingSetting.builder().applyMutation(intentClosingSetting)).build());
        }

        public Builder inputContexts(Collection<InputContext> var1);

        public Builder inputContexts(InputContext ... var1);

        public Builder inputContexts(Consumer<InputContext.Builder> ... var1);

        public Builder outputContexts(Collection<OutputContext> var1);

        public Builder outputContexts(OutputContext ... var1);

        public Builder outputContexts(Consumer<OutputContext.Builder> ... var1);

        public Builder kendraConfiguration(KendraConfiguration var1);

        default public Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return this.kendraConfiguration((KendraConfiguration)((KendraConfiguration.Builder)KendraConfiguration.builder().applyMutation(kendraConfiguration)).build());
        }

        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder initialResponseSetting(InitialResponseSetting var1);

        default public Builder initialResponseSetting(Consumer<InitialResponseSetting.Builder> initialResponseSetting) {
            return this.initialResponseSetting((InitialResponseSetting)((InitialResponseSetting.Builder)InitialResponseSetting.builder().applyMutation(initialResponseSetting)).build());
        }

        public Builder qnAIntentConfiguration(QnAIntentConfiguration var1);

        default public Builder qnAIntentConfiguration(Consumer<QnAIntentConfiguration.Builder> qnAIntentConfiguration) {
            return this.qnAIntentConfiguration((QnAIntentConfiguration)((QnAIntentConfiguration.Builder)QnAIntentConfiguration.builder().applyMutation(qnAIntentConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

