/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse;

public class ListTestExecutionResultItemsIterable
implements SdkIterable<ListTestExecutionResultItemsResponse> {
    private final LexModelsV2Client client;
    private final ListTestExecutionResultItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestExecutionResultItemsIterable(LexModelsV2Client client, ListTestExecutionResultItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestExecutionResultItemsResponseFetcher();
    }

    public Iterator<ListTestExecutionResultItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestExecutionResultItemsResponseFetcher
    implements SyncPageFetcher<ListTestExecutionResultItemsResponse> {
        private ListTestExecutionResultItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestExecutionResultItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestExecutionResultItemsResponse nextPage(ListTestExecutionResultItemsResponse previousPage) {
            if (previousPage == null) {
                return ListTestExecutionResultItemsIterable.this.client.listTestExecutionResultItems(ListTestExecutionResultItemsIterable.this.firstRequest);
            }
            return ListTestExecutionResultItemsIterable.this.client.listTestExecutionResultItems((ListTestExecutionResultItemsRequest)((Object)ListTestExecutionResultItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

