/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTestSetRequest extends LexModelsV2Request implements
        ToCopyableBuilder<UpdateTestSetRequest.Builder, UpdateTestSetRequest> {
    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetId").getter(getter(UpdateTestSetRequest::testSetId)).setter(setter(Builder::testSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testSetId").build()).build();

    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetName").getter(getter(UpdateTestSetRequest::testSetName)).setter(setter(Builder::testSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateTestSetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_ID_FIELD,
            TEST_SET_NAME_FIELD, DESCRIPTION_FIELD));

    private final String testSetId;

    private final String testSetName;

    private final String description;

    private UpdateTestSetRequest(BuilderImpl builder) {
        super(builder);
        this.testSetId = builder.testSetId;
        this.testSetName = builder.testSetName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The test set Id for which update test operation to be performed.
     * </p>
     * 
     * @return The test set Id for which update test operation to be performed.
     */
    public final String testSetId() {
        return testSetId;
    }

    /**
     * <p>
     * The new test set name.
     * </p>
     * 
     * @return The new test set name.
     */
    public final String testSetName() {
        return testSetName;
    }

    /**
     * <p>
     * The new test set description.
     * </p>
     * 
     * @return The new test set description.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestSetRequest)) {
            return false;
        }
        UpdateTestSetRequest other = (UpdateTestSetRequest) obj;
        return Objects.equals(testSetId(), other.testSetId()) && Objects.equals(testSetName(), other.testSetName())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTestSetRequest").add("TestSetId", testSetId()).add("TestSetName", testSetName())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSetId":
            return Optional.ofNullable(clazz.cast(testSetId()));
        case "testSetName":
            return Optional.ofNullable(clazz.cast(testSetName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTestSetRequest, T> g) {
        return obj -> g.apply((UpdateTestSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTestSetRequest> {
        /**
         * <p>
         * The test set Id for which update test operation to be performed.
         * </p>
         * 
         * @param testSetId
         *        The test set Id for which update test operation to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetId(String testSetId);

        /**
         * <p>
         * The new test set name.
         * </p>
         * 
         * @param testSetName
         *        The new test set name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetName(String testSetName);

        /**
         * <p>
         * The new test set description.
         * </p>
         * 
         * @param description
         *        The new test set description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String testSetId;

        private String testSetName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTestSetRequest model) {
            super(model);
            testSetId(model.testSetId);
            testSetName(model.testSetName);
            description(model.description);
        }

        public final String getTestSetId() {
            return testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final String getTestSetName() {
            return testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTestSetRequest build() {
            return new UpdateTestSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
