/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Amazon CloudWatch Logs destination log group for conversation text logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextLogDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<TextLogDestination.Builder, TextLogDestination> {
    private static final SdkField<CloudWatchLogGroupLogDestination> CLOUD_WATCH_FIELD = SdkField
            .<CloudWatchLogGroupLogDestination> builder(MarshallingType.SDK_POJO).memberName("cloudWatch")
            .getter(getter(TextLogDestination::cloudWatch)).setter(setter(Builder::cloudWatch))
            .constructor(CloudWatchLogGroupLogDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogGroupLogDestination cloudWatch;

    private TextLogDestination(BuilderImpl builder) {
        this.cloudWatch = builder.cloudWatch;
    }

    /**
     * <p>
     * Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered.
     * </p>
     * 
     * @return Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered.
     */
    public final CloudWatchLogGroupLogDestination cloudWatch() {
        return cloudWatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextLogDestination)) {
            return false;
        }
        TextLogDestination other = (TextLogDestination) obj;
        return Objects.equals(cloudWatch(), other.cloudWatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextLogDestination").add("CloudWatch", cloudWatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatch":
            return Optional.ofNullable(clazz.cast(cloudWatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextLogDestination, T> g) {
        return obj -> g.apply((TextLogDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextLogDestination> {
        /**
         * <p>
         * Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered.
         * </p>
         * 
         * @param cloudWatch
         *        Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatch(CloudWatchLogGroupLogDestination cloudWatch);

        /**
         * <p>
         * Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogGroupLogDestination.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogGroupLogDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogGroupLogDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatch(CloudWatchLogGroupLogDestination)}.
         * 
         * @param cloudWatch
         *        a consumer that will call methods on {@link CloudWatchLogGroupLogDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatch(CloudWatchLogGroupLogDestination)
         */
        default Builder cloudWatch(Consumer<CloudWatchLogGroupLogDestination.Builder> cloudWatch) {
            return cloudWatch(CloudWatchLogGroupLogDestination.builder().applyMutation(cloudWatch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogGroupLogDestination cloudWatch;

        private BuilderImpl() {
        }

        private BuilderImpl(TextLogDestination model) {
            cloudWatch(model.cloudWatch);
        }

        public final CloudWatchLogGroupLogDestination.Builder getCloudWatch() {
            return cloudWatch != null ? cloudWatch.toBuilder() : null;
        }

        public final void setCloudWatch(CloudWatchLogGroupLogDestination.BuilderImpl cloudWatch) {
            this.cloudWatch = cloudWatch != null ? cloudWatch.build() : null;
        }

        @Override
        public final Builder cloudWatch(CloudWatchLogGroupLogDestination cloudWatch) {
            this.cloudWatch = cloudWatch;
            return this;
        }

        @Override
        public TextLogDestination build() {
            return new TextLogDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
