/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the counts for a slot resolution in the results of a test execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotResolutionTestResultItemCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotResolutionTestResultItemCounts.Builder, SlotResolutionTestResultItemCounts> {
    private static final SdkField<Integer> TOTAL_RESULT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResultCount").getter(getter(SlotResolutionTestResultItemCounts::totalResultCount))
            .setter(setter(Builder::totalResultCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResultCount").build()).build();

    private static final SdkField<Map<String, Integer>> SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("speechTranscriptionResultCounts")
            .getter(getter(SlotResolutionTestResultItemCounts::speechTranscriptionResultCountsAsStrings))
            .setter(setter(Builder::speechTranscriptionResultCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResultCounts")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> SLOT_MATCH_RESULT_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("slotMatchResultCounts")
            .getter(getter(SlotResolutionTestResultItemCounts::slotMatchResultCountsAsStrings))
            .setter(setter(Builder::slotMatchResultCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotMatchResultCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_RESULT_COUNT_FIELD,
            SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD, SLOT_MATCH_RESULT_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalResultCount;

    private final Map<String, Integer> speechTranscriptionResultCounts;

    private final Map<String, Integer> slotMatchResultCounts;

    private SlotResolutionTestResultItemCounts(BuilderImpl builder) {
        this.totalResultCount = builder.totalResultCount;
        this.speechTranscriptionResultCounts = builder.speechTranscriptionResultCounts;
        this.slotMatchResultCounts = builder.slotMatchResultCounts;
    }

    /**
     * <p>
     * The total number of results.
     * </p>
     * 
     * @return The total number of results.
     */
    public final Integer totalResultCount() {
        return totalResultCount;
    }

    /**
     * <p>
     * The number of matched, mismatched and execution error results for speech transcription for the slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpeechTranscriptionResultCounts}
     * method.
     * </p>
     * 
     * @return The number of matched, mismatched and execution error results for speech transcription for the slot.
     */
    public final Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(speechTranscriptionResultCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the SpeechTranscriptionResultCounts
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSpeechTranscriptionResultCounts() {
        return speechTranscriptionResultCounts != null && !(speechTranscriptionResultCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of matched, mismatched and execution error results for speech transcription for the slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpeechTranscriptionResultCounts}
     * method.
     * </p>
     * 
     * @return The number of matched, mismatched and execution error results for speech transcription for the slot.
     */
    public final Map<String, Integer> speechTranscriptionResultCountsAsStrings() {
        return speechTranscriptionResultCounts;
    }

    /**
     * <p>
     * The number of matched and mismatched results for slot resolution for the slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotMatchResultCounts} method.
     * </p>
     * 
     * @return The number of matched and mismatched results for slot resolution for the slot.
     */
    public final Map<TestResultMatchStatus, Integer> slotMatchResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(slotMatchResultCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotMatchResultCounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSlotMatchResultCounts() {
        return slotMatchResultCounts != null && !(slotMatchResultCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of matched and mismatched results for slot resolution for the slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotMatchResultCounts} method.
     * </p>
     * 
     * @return The number of matched and mismatched results for slot resolution for the slot.
     */
    public final Map<String, Integer> slotMatchResultCountsAsStrings() {
        return slotMatchResultCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalResultCount());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSpeechTranscriptionResultCounts() ? speechTranscriptionResultCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotMatchResultCounts() ? slotMatchResultCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotResolutionTestResultItemCounts)) {
            return false;
        }
        SlotResolutionTestResultItemCounts other = (SlotResolutionTestResultItemCounts) obj;
        return Objects.equals(totalResultCount(), other.totalResultCount())
                && hasSpeechTranscriptionResultCounts() == other.hasSpeechTranscriptionResultCounts()
                && Objects.equals(speechTranscriptionResultCountsAsStrings(), other.speechTranscriptionResultCountsAsStrings())
                && hasSlotMatchResultCounts() == other.hasSlotMatchResultCounts()
                && Objects.equals(slotMatchResultCountsAsStrings(), other.slotMatchResultCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SlotResolutionTestResultItemCounts")
                .add("TotalResultCount", totalResultCount())
                .add("SpeechTranscriptionResultCounts",
                        hasSpeechTranscriptionResultCounts() ? speechTranscriptionResultCountsAsStrings() : null)
                .add("SlotMatchResultCounts", hasSlotMatchResultCounts() ? slotMatchResultCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalResultCount":
            return Optional.ofNullable(clazz.cast(totalResultCount()));
        case "speechTranscriptionResultCounts":
            return Optional.ofNullable(clazz.cast(speechTranscriptionResultCountsAsStrings()));
        case "slotMatchResultCounts":
            return Optional.ofNullable(clazz.cast(slotMatchResultCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotResolutionTestResultItemCounts, T> g) {
        return obj -> g.apply((SlotResolutionTestResultItemCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotResolutionTestResultItemCounts> {
        /**
         * <p>
         * The total number of results.
         * </p>
         * 
         * @param totalResultCount
         *        The total number of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResultCount(Integer totalResultCount);

        /**
         * <p>
         * The number of matched, mismatched and execution error results for speech transcription for the slot.
         * </p>
         * 
         * @param speechTranscriptionResultCounts
         *        The number of matched, mismatched and execution error results for speech transcription for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts);

        /**
         * <p>
         * The number of matched, mismatched and execution error results for speech transcription for the slot.
         * </p>
         * 
         * @param speechTranscriptionResultCounts
         *        The number of matched, mismatched and execution error results for speech transcription for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts);

        /**
         * <p>
         * The number of matched and mismatched results for slot resolution for the slot.
         * </p>
         * 
         * @param slotMatchResultCounts
         *        The number of matched and mismatched results for slot resolution for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotMatchResultCountsWithStrings(Map<String, Integer> slotMatchResultCounts);

        /**
         * <p>
         * The number of matched and mismatched results for slot resolution for the slot.
         * </p>
         * 
         * @param slotMatchResultCounts
         *        The number of matched and mismatched results for slot resolution for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotMatchResultCounts(Map<TestResultMatchStatus, Integer> slotMatchResultCounts);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalResultCount;

        private Map<String, Integer> speechTranscriptionResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Integer> slotMatchResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotResolutionTestResultItemCounts model) {
            totalResultCount(model.totalResultCount);
            speechTranscriptionResultCountsWithStrings(model.speechTranscriptionResultCounts);
            slotMatchResultCountsWithStrings(model.slotMatchResultCounts);
        }

        public final Integer getTotalResultCount() {
            return totalResultCount;
        }

        public final void setTotalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
        }

        @Override
        public final Builder totalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
            return this;
        }

        public final Map<String, Integer> getSpeechTranscriptionResultCounts() {
            if (speechTranscriptionResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return speechTranscriptionResultCounts;
        }

        public final void setSpeechTranscriptionResultCounts(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
        }

        @Override
        public final Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
            return this;
        }

        @Override
        public final Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier
                    .copyEnumToString(speechTranscriptionResultCounts);
            return this;
        }

        public final Map<String, Integer> getSlotMatchResultCounts() {
            if (slotMatchResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return slotMatchResultCounts;
        }

        public final void setSlotMatchResultCounts(Map<String, Integer> slotMatchResultCounts) {
            this.slotMatchResultCounts = TestResultMatchStatusCountMapCopier.copy(slotMatchResultCounts);
        }

        @Override
        public final Builder slotMatchResultCountsWithStrings(Map<String, Integer> slotMatchResultCounts) {
            this.slotMatchResultCounts = TestResultMatchStatusCountMapCopier.copy(slotMatchResultCounts);
            return this;
        }

        @Override
        public final Builder slotMatchResultCounts(Map<TestResultMatchStatus, Integer> slotMatchResultCounts) {
            this.slotMatchResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(slotMatchResultCounts);
            return this;
        }

        @Override
        public SlotResolutionTestResultItemCounts build() {
            return new SlotResolutionTestResultItemCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
