/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings on a prompt attempt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptAttemptSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptAttemptSpecification.Builder, PromptAttemptSpecification> {
    private static final SdkField<Boolean> ALLOW_INTERRUPT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowInterrupt").getter(getter(PromptAttemptSpecification::allowInterrupt))
            .setter(setter(Builder::allowInterrupt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowInterrupt").build()).build();

    private static final SdkField<AllowedInputTypes> ALLOWED_INPUT_TYPES_FIELD = SdkField
            .<AllowedInputTypes> builder(MarshallingType.SDK_POJO).memberName("allowedInputTypes")
            .getter(getter(PromptAttemptSpecification::allowedInputTypes)).setter(setter(Builder::allowedInputTypes))
            .constructor(AllowedInputTypes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedInputTypes").build()).build();

    private static final SdkField<AudioAndDTMFInputSpecification> AUDIO_AND_DTMF_INPUT_SPECIFICATION_FIELD = SdkField
            .<AudioAndDTMFInputSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("audioAndDTMFInputSpecification")
            .getter(getter(PromptAttemptSpecification::audioAndDTMFInputSpecification))
            .setter(setter(Builder::audioAndDTMFInputSpecification))
            .constructor(AudioAndDTMFInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioAndDTMFInputSpecification")
                    .build()).build();

    private static final SdkField<TextInputSpecification> TEXT_INPUT_SPECIFICATION_FIELD = SdkField
            .<TextInputSpecification> builder(MarshallingType.SDK_POJO).memberName("textInputSpecification")
            .getter(getter(PromptAttemptSpecification::textInputSpecification)).setter(setter(Builder::textInputSpecification))
            .constructor(TextInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textInputSpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_INTERRUPT_FIELD,
            ALLOWED_INPUT_TYPES_FIELD, AUDIO_AND_DTMF_INPUT_SPECIFICATION_FIELD, TEXT_INPUT_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowInterrupt;

    private final AllowedInputTypes allowedInputTypes;

    private final AudioAndDTMFInputSpecification audioAndDTMFInputSpecification;

    private final TextInputSpecification textInputSpecification;

    private PromptAttemptSpecification(BuilderImpl builder) {
        this.allowInterrupt = builder.allowInterrupt;
        this.allowedInputTypes = builder.allowedInputTypes;
        this.audioAndDTMFInputSpecification = builder.audioAndDTMFInputSpecification;
        this.textInputSpecification = builder.textInputSpecification;
    }

    /**
     * <p>
     * Indicates whether the user can interrupt a speech prompt attempt from the bot.
     * </p>
     * 
     * @return Indicates whether the user can interrupt a speech prompt attempt from the bot.
     */
    public final Boolean allowInterrupt() {
        return allowInterrupt;
    }

    /**
     * <p>
     * Indicates the allowed input types of the prompt attempt.
     * </p>
     * 
     * @return Indicates the allowed input types of the prompt attempt.
     */
    public final AllowedInputTypes allowedInputTypes() {
        return allowedInputTypes;
    }

    /**
     * <p>
     * Specifies the settings on audio and DTMF input.
     * </p>
     * 
     * @return Specifies the settings on audio and DTMF input.
     */
    public final AudioAndDTMFInputSpecification audioAndDTMFInputSpecification() {
        return audioAndDTMFInputSpecification;
    }

    /**
     * <p>
     * Specifies the settings on text input.
     * </p>
     * 
     * @return Specifies the settings on text input.
     */
    public final TextInputSpecification textInputSpecification() {
        return textInputSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowInterrupt());
        hashCode = 31 * hashCode + Objects.hashCode(allowedInputTypes());
        hashCode = 31 * hashCode + Objects.hashCode(audioAndDTMFInputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(textInputSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptAttemptSpecification)) {
            return false;
        }
        PromptAttemptSpecification other = (PromptAttemptSpecification) obj;
        return Objects.equals(allowInterrupt(), other.allowInterrupt())
                && Objects.equals(allowedInputTypes(), other.allowedInputTypes())
                && Objects.equals(audioAndDTMFInputSpecification(), other.audioAndDTMFInputSpecification())
                && Objects.equals(textInputSpecification(), other.textInputSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptAttemptSpecification").add("AllowInterrupt", allowInterrupt())
                .add("AllowedInputTypes", allowedInputTypes())
                .add("AudioAndDTMFInputSpecification", audioAndDTMFInputSpecification())
                .add("TextInputSpecification", textInputSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowInterrupt":
            return Optional.ofNullable(clazz.cast(allowInterrupt()));
        case "allowedInputTypes":
            return Optional.ofNullable(clazz.cast(allowedInputTypes()));
        case "audioAndDTMFInputSpecification":
            return Optional.ofNullable(clazz.cast(audioAndDTMFInputSpecification()));
        case "textInputSpecification":
            return Optional.ofNullable(clazz.cast(textInputSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptAttemptSpecification, T> g) {
        return obj -> g.apply((PromptAttemptSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptAttemptSpecification> {
        /**
         * <p>
         * Indicates whether the user can interrupt a speech prompt attempt from the bot.
         * </p>
         * 
         * @param allowInterrupt
         *        Indicates whether the user can interrupt a speech prompt attempt from the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowInterrupt(Boolean allowInterrupt);

        /**
         * <p>
         * Indicates the allowed input types of the prompt attempt.
         * </p>
         * 
         * @param allowedInputTypes
         *        Indicates the allowed input types of the prompt attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedInputTypes(AllowedInputTypes allowedInputTypes);

        /**
         * <p>
         * Indicates the allowed input types of the prompt attempt.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllowedInputTypes.Builder} avoiding the
         * need to create one manually via {@link AllowedInputTypes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllowedInputTypes.Builder#build()} is called immediately and its
         * result is passed to {@link #allowedInputTypes(AllowedInputTypes)}.
         * 
         * @param allowedInputTypes
         *        a consumer that will call methods on {@link AllowedInputTypes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedInputTypes(AllowedInputTypes)
         */
        default Builder allowedInputTypes(Consumer<AllowedInputTypes.Builder> allowedInputTypes) {
            return allowedInputTypes(AllowedInputTypes.builder().applyMutation(allowedInputTypes).build());
        }

        /**
         * <p>
         * Specifies the settings on audio and DTMF input.
         * </p>
         * 
         * @param audioAndDTMFInputSpecification
         *        Specifies the settings on audio and DTMF input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioAndDTMFInputSpecification(AudioAndDTMFInputSpecification audioAndDTMFInputSpecification);

        /**
         * <p>
         * Specifies the settings on audio and DTMF input.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioAndDTMFInputSpecification.Builder}
         * avoiding the need to create one manually via {@link AudioAndDTMFInputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioAndDTMFInputSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #audioAndDTMFInputSpecification(AudioAndDTMFInputSpecification)}.
         * 
         * @param audioAndDTMFInputSpecification
         *        a consumer that will call methods on {@link AudioAndDTMFInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioAndDTMFInputSpecification(AudioAndDTMFInputSpecification)
         */
        default Builder audioAndDTMFInputSpecification(
                Consumer<AudioAndDTMFInputSpecification.Builder> audioAndDTMFInputSpecification) {
            return audioAndDTMFInputSpecification(AudioAndDTMFInputSpecification.builder()
                    .applyMutation(audioAndDTMFInputSpecification).build());
        }

        /**
         * <p>
         * Specifies the settings on text input.
         * </p>
         * 
         * @param textInputSpecification
         *        Specifies the settings on text input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textInputSpecification(TextInputSpecification textInputSpecification);

        /**
         * <p>
         * Specifies the settings on text input.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextInputSpecification.Builder} avoiding
         * the need to create one manually via {@link TextInputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextInputSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #textInputSpecification(TextInputSpecification)}.
         * 
         * @param textInputSpecification
         *        a consumer that will call methods on {@link TextInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textInputSpecification(TextInputSpecification)
         */
        default Builder textInputSpecification(Consumer<TextInputSpecification.Builder> textInputSpecification) {
            return textInputSpecification(TextInputSpecification.builder().applyMutation(textInputSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowInterrupt;

        private AllowedInputTypes allowedInputTypes;

        private AudioAndDTMFInputSpecification audioAndDTMFInputSpecification;

        private TextInputSpecification textInputSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptAttemptSpecification model) {
            allowInterrupt(model.allowInterrupt);
            allowedInputTypes(model.allowedInputTypes);
            audioAndDTMFInputSpecification(model.audioAndDTMFInputSpecification);
            textInputSpecification(model.textInputSpecification);
        }

        public final Boolean getAllowInterrupt() {
            return allowInterrupt;
        }

        public final void setAllowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
        }

        @Override
        public final Builder allowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
            return this;
        }

        public final AllowedInputTypes.Builder getAllowedInputTypes() {
            return allowedInputTypes != null ? allowedInputTypes.toBuilder() : null;
        }

        public final void setAllowedInputTypes(AllowedInputTypes.BuilderImpl allowedInputTypes) {
            this.allowedInputTypes = allowedInputTypes != null ? allowedInputTypes.build() : null;
        }

        @Override
        public final Builder allowedInputTypes(AllowedInputTypes allowedInputTypes) {
            this.allowedInputTypes = allowedInputTypes;
            return this;
        }

        public final AudioAndDTMFInputSpecification.Builder getAudioAndDTMFInputSpecification() {
            return audioAndDTMFInputSpecification != null ? audioAndDTMFInputSpecification.toBuilder() : null;
        }

        public final void setAudioAndDTMFInputSpecification(
                AudioAndDTMFInputSpecification.BuilderImpl audioAndDTMFInputSpecification) {
            this.audioAndDTMFInputSpecification = audioAndDTMFInputSpecification != null ? audioAndDTMFInputSpecification.build()
                    : null;
        }

        @Override
        public final Builder audioAndDTMFInputSpecification(AudioAndDTMFInputSpecification audioAndDTMFInputSpecification) {
            this.audioAndDTMFInputSpecification = audioAndDTMFInputSpecification;
            return this;
        }

        public final TextInputSpecification.Builder getTextInputSpecification() {
            return textInputSpecification != null ? textInputSpecification.toBuilder() : null;
        }

        public final void setTextInputSpecification(TextInputSpecification.BuilderImpl textInputSpecification) {
            this.textInputSpecification = textInputSpecification != null ? textInputSpecification.build() : null;
        }

        @Override
        public final Builder textInputSpecification(TextInputSpecification textInputSpecification) {
            this.textInputSpecification = textInputSpecification;
            return this;
        }

        @Override
        public PromptAttemptSpecification build() {
            return new PromptAttemptSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
