/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the overall test results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverallTestResults implements SdkPojo, Serializable,
        ToCopyableBuilder<OverallTestResults.Builder, OverallTestResults> {
    private static final SdkField<List<OverallTestResultItem>> ITEMS_FIELD = SdkField
            .<List<OverallTestResultItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(OverallTestResults::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OverallTestResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(OverallTestResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<OverallTestResultItem> items;

    private OverallTestResults(BuilderImpl builder) {
        this.items = builder.items;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the overall test results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return A list of the overall test results.
     */
    public final List<OverallTestResultItem> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverallTestResults)) {
            return false;
        }
        OverallTestResults other = (OverallTestResults) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OverallTestResults").add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OverallTestResults, T> g) {
        return obj -> g.apply((OverallTestResults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OverallTestResults> {
        /**
         * <p>
         * A list of the overall test results.
         * </p>
         * 
         * @param items
         *        A list of the overall test results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<OverallTestResultItem> items);

        /**
         * <p>
         * A list of the overall test results.
         * </p>
         * 
         * @param items
         *        A list of the overall test results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(OverallTestResultItem... items);

        /**
         * <p>
         * A list of the overall test results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<OverallTestResultItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<OverallTestResultItem>)
         */
        Builder items(Consumer<OverallTestResultItem.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private List<OverallTestResultItem> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OverallTestResults model) {
            items(model.items);
        }

        public final List<OverallTestResultItem.Builder> getItems() {
            List<OverallTestResultItem.Builder> result = OverallTestResultItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<OverallTestResultItem.BuilderImpl> items) {
            this.items = OverallTestResultItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<OverallTestResultItem> items) {
            this.items = OverallTestResultItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(OverallTestResultItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<OverallTestResultItem.Builder>... items) {
            items(Stream.of(items).map(c -> OverallTestResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OverallTestResults build() {
            return new OverallTestResults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
