/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestSetsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListTestSetsResponse.Builder, ListTestSetsResponse> {
    private static final SdkField<List<TestSetSummary>> TEST_SETS_FIELD = SdkField
            .<List<TestSetSummary>> builder(MarshallingType.LIST)
            .memberName("testSets")
            .getter(getter(ListTestSetsResponse::testSets))
            .setter(setter(Builder::testSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TestSetSummary> testSets;

    private final String nextToken;

    private ListTestSetsResponse(BuilderImpl builder) {
        super(builder);
        this.testSets = builder.testSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTestSets() {
        return testSets != null && !(testSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selected test sets in a list of test sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestSets} method.
     * </p>
     * 
     * @return The selected test sets in a list of test sets.
     */
    public final List<TestSetSummary> testSets() {
        return testSets;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the ListTestSets operation. If
     * the nextToken field is present, you send the contents as the nextToken parameter of a ListTestSets operation
     * request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the ListTestSets
     *         operation. If the nextToken field is present, you send the contents as the nextToken parameter of a
     *         ListTestSets operation request to get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTestSets() ? testSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestSetsResponse)) {
            return false;
        }
        ListTestSetsResponse other = (ListTestSetsResponse) obj;
        return hasTestSets() == other.hasTestSets() && Objects.equals(testSets(), other.testSets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestSetsResponse").add("TestSets", hasTestSets() ? testSets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSets":
            return Optional.ofNullable(clazz.cast(testSets()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestSetsResponse, T> g) {
        return obj -> g.apply((ListTestSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListTestSetsResponse> {
        /**
         * <p>
         * The selected test sets in a list of test sets.
         * </p>
         * 
         * @param testSets
         *        The selected test sets in a list of test sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSets(Collection<TestSetSummary> testSets);

        /**
         * <p>
         * The selected test sets in a list of test sets.
         * </p>
         * 
         * @param testSets
         *        The selected test sets in a list of test sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSets(TestSetSummary... testSets);

        /**
         * <p>
         * The selected test sets in a list of test sets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #testSets(List<TestSetSummary>)}.
         * 
         * @param testSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testSets(java.util.Collection<TestSetSummary>)
         */
        Builder testSets(Consumer<TestSetSummary.Builder>... testSets);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the ListTestSets operation.
         * If the nextToken field is present, you send the contents as the nextToken parameter of a ListTestSets
         * operation request to get the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the ListTestSets
         *        operation. If the nextToken field is present, you send the contents as the nextToken parameter of a
         *        ListTestSets operation request to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private List<TestSetSummary> testSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestSetsResponse model) {
            super(model);
            testSets(model.testSets);
            nextToken(model.nextToken);
        }

        public final List<TestSetSummary.Builder> getTestSets() {
            List<TestSetSummary.Builder> result = TestSetSummaryListCopier.copyToBuilder(this.testSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestSets(Collection<TestSetSummary.BuilderImpl> testSets) {
            this.testSets = TestSetSummaryListCopier.copyFromBuilder(testSets);
        }

        @Override
        public final Builder testSets(Collection<TestSetSummary> testSets) {
            this.testSets = TestSetSummaryListCopier.copy(testSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSets(TestSetSummary... testSets) {
            testSets(Arrays.asList(testSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSets(Consumer<TestSetSummary.Builder>... testSets) {
            testSets(Stream.of(testSets).map(c -> TestSetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestSetsResponse build() {
            return new ListTestSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
