/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBuiltInSlotTypesResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBuiltInSlotTypesResponse.Builder, ListBuiltInSlotTypesResponse> {
    private static final SdkField<List<BuiltInSlotTypeSummary>> BUILT_IN_SLOT_TYPE_SUMMARIES_FIELD = SdkField
            .<List<BuiltInSlotTypeSummary>> builder(MarshallingType.LIST)
            .memberName("builtInSlotTypeSummaries")
            .getter(getter(ListBuiltInSlotTypesResponse::builtInSlotTypeSummaries))
            .setter(setter(Builder::builtInSlotTypeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("builtInSlotTypeSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BuiltInSlotTypeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BuiltInSlotTypeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBuiltInSlotTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListBuiltInSlotTypesResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUILT_IN_SLOT_TYPE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, LOCALE_ID_FIELD));

    private final List<BuiltInSlotTypeSummary> builtInSlotTypeSummaries;

    private final String nextToken;

    private final String localeId;

    private ListBuiltInSlotTypesResponse(BuilderImpl builder) {
        super(builder);
        this.builtInSlotTypeSummaries = builder.builtInSlotTypeSummaries;
        this.nextToken = builder.nextToken;
        this.localeId = builder.localeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BuiltInSlotTypeSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBuiltInSlotTypeSummaries() {
        return builtInSlotTypeSummaries != null && !(builtInSlotTypeSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the built-in slot types that meet the filter criteria specified in the request. The
     * length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot
     * types available, the <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuiltInSlotTypeSummaries} method.
     * </p>
     * 
     * @return Summary information for the built-in slot types that meet the filter criteria specified in the request.
     *         The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
     *         more slot types available, the <code>nextToken</code> field contains a token to get the next page of
     *         results.
     */
    public final List<BuiltInSlotTypeSummary> builtInSlotTypeSummaries() {
        return builtInSlotTypeSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the
     * <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the
     * contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to get
     * the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the
     *         contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request
     *         to get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The language and locale of the slot types in the list.
     * </p>
     * 
     * @return The language and locale of the slot types in the list.
     */
    public final String localeId() {
        return localeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBuiltInSlotTypeSummaries() ? builtInSlotTypeSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuiltInSlotTypesResponse)) {
            return false;
        }
        ListBuiltInSlotTypesResponse other = (ListBuiltInSlotTypesResponse) obj;
        return hasBuiltInSlotTypeSummaries() == other.hasBuiltInSlotTypeSummaries()
                && Objects.equals(builtInSlotTypeSummaries(), other.builtInSlotTypeSummaries())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(localeId(), other.localeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBuiltInSlotTypesResponse")
                .add("BuiltInSlotTypeSummaries", hasBuiltInSlotTypeSummaries() ? builtInSlotTypeSummaries() : null)
                .add("NextToken", nextToken()).add("LocaleId", localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "builtInSlotTypeSummaries":
            return Optional.ofNullable(clazz.cast(builtInSlotTypeSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuiltInSlotTypesResponse, T> g) {
        return obj -> g.apply((ListBuiltInSlotTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBuiltInSlotTypesResponse> {
        /**
         * <p>
         * Summary information for the built-in slot types that meet the filter criteria specified in the request. The
         * length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         * slot types available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param builtInSlotTypeSummaries
         *        Summary information for the built-in slot types that meet the filter criteria specified in the
         *        request. The length of the list is specified in the <code>maxResults</code> parameter of the request.
         *        If there are more slot types available, the <code>nextToken</code> field contains a token to get the
         *        next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builtInSlotTypeSummaries(Collection<BuiltInSlotTypeSummary> builtInSlotTypeSummaries);

        /**
         * <p>
         * Summary information for the built-in slot types that meet the filter criteria specified in the request. The
         * length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         * slot types available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param builtInSlotTypeSummaries
         *        Summary information for the built-in slot types that meet the filter criteria specified in the
         *        request. The length of the list is specified in the <code>maxResults</code> parameter of the request.
         *        If there are more slot types available, the <code>nextToken</code> field contains a token to get the
         *        next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builtInSlotTypeSummaries(BuiltInSlotTypeSummary... builtInSlotTypeSummaries);

        /**
         * <p>
         * Summary information for the built-in slot types that meet the filter criteria specified in the request. The
         * length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         * slot types available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #builtInSlotTypeSummaries(List<BuiltInSlotTypeSummary>)}.
         * 
         * @param builtInSlotTypeSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #builtInSlotTypeSummaries(java.util.Collection<BuiltInSlotTypeSummary>)
         */
        Builder builtInSlotTypeSummaries(Consumer<BuiltInSlotTypeSummary.Builder>... builtInSlotTypeSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the
         * <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the
         * contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to
         * get the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send
         *        the contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation
         *        request to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The language and locale of the slot types in the list.
         * </p>
         * 
         * @param localeId
         *        The language and locale of the slot types in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private List<BuiltInSlotTypeSummary> builtInSlotTypeSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuiltInSlotTypesResponse model) {
            super(model);
            builtInSlotTypeSummaries(model.builtInSlotTypeSummaries);
            nextToken(model.nextToken);
            localeId(model.localeId);
        }

        public final List<BuiltInSlotTypeSummary.Builder> getBuiltInSlotTypeSummaries() {
            List<BuiltInSlotTypeSummary.Builder> result = BuiltInSlotTypeSummaryListCopier
                    .copyToBuilder(this.builtInSlotTypeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuiltInSlotTypeSummaries(Collection<BuiltInSlotTypeSummary.BuilderImpl> builtInSlotTypeSummaries) {
            this.builtInSlotTypeSummaries = BuiltInSlotTypeSummaryListCopier.copyFromBuilder(builtInSlotTypeSummaries);
        }

        @Override
        public final Builder builtInSlotTypeSummaries(Collection<BuiltInSlotTypeSummary> builtInSlotTypeSummaries) {
            this.builtInSlotTypeSummaries = BuiltInSlotTypeSummaryListCopier.copy(builtInSlotTypeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builtInSlotTypeSummaries(BuiltInSlotTypeSummary... builtInSlotTypeSummaries) {
            builtInSlotTypeSummaries(Arrays.asList(builtInSlotTypeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builtInSlotTypeSummaries(Consumer<BuiltInSlotTypeSummary.Builder>... builtInSlotTypeSummaries) {
            builtInSlotTypeSummaries(Stream.of(builtInSlotTypeSummaries)
                    .map(c -> BuiltInSlotTypeSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public ListBuiltInSlotTypesResponse build() {
            return new ListBuiltInSlotTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
