/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestExecutionArtifactsUrlRequest extends LexModelsV2Request implements
        ToCopyableBuilder<GetTestExecutionArtifactsUrlRequest.Builder, GetTestExecutionArtifactsUrlRequest> {
    private static final SdkField<String> TEST_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionId").getter(getter(GetTestExecutionArtifactsUrlRequest::testExecutionId))
            .setter(setter(Builder::testExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testExecutionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTION_ID_FIELD));

    private final String testExecutionId;

    private GetTestExecutionArtifactsUrlRequest(BuilderImpl builder) {
        super(builder);
        this.testExecutionId = builder.testExecutionId;
    }

    /**
     * <p>
     * The unique identifier of the completed test execution.
     * </p>
     * 
     * @return The unique identifier of the completed test execution.
     */
    public final String testExecutionId() {
        return testExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestExecutionArtifactsUrlRequest)) {
            return false;
        }
        GetTestExecutionArtifactsUrlRequest other = (GetTestExecutionArtifactsUrlRequest) obj;
        return Objects.equals(testExecutionId(), other.testExecutionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestExecutionArtifactsUrlRequest").add("TestExecutionId", testExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testExecutionId":
            return Optional.ofNullable(clazz.cast(testExecutionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTestExecutionArtifactsUrlRequest, T> g) {
        return obj -> g.apply((GetTestExecutionArtifactsUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTestExecutionArtifactsUrlRequest> {
        /**
         * <p>
         * The unique identifier of the completed test execution.
         * </p>
         * 
         * @param testExecutionId
         *        The unique identifier of the completed test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testExecutionId(String testExecutionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String testExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestExecutionArtifactsUrlRequest model) {
            super(model);
            testExecutionId(model.testExecutionId);
        }

        public final String getTestExecutionId() {
            return testExecutionId;
        }

        public final void setTestExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
        }

        @Override
        public final Builder testExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTestExecutionArtifactsUrlRequest build() {
            return new GetTestExecutionArtifactsUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
