/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information for updating the user on the progress of fulfilling an intent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FulfillmentUpdatesSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<FulfillmentUpdatesSpecification.Builder, FulfillmentUpdatesSpecification> {
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(FulfillmentUpdatesSpecification::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final SdkField<FulfillmentStartResponseSpecification> START_RESPONSE_FIELD = SdkField
            .<FulfillmentStartResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("startResponse")
            .getter(getter(FulfillmentUpdatesSpecification::startResponse)).setter(setter(Builder::startResponse))
            .constructor(FulfillmentStartResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startResponse").build()).build();

    private static final SdkField<FulfillmentUpdateResponseSpecification> UPDATE_RESPONSE_FIELD = SdkField
            .<FulfillmentUpdateResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("updateResponse")
            .getter(getter(FulfillmentUpdatesSpecification::updateResponse)).setter(setter(Builder::updateResponse))
            .constructor(FulfillmentUpdateResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateResponse").build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutInSeconds").getter(getter(FulfillmentUpdatesSpecification::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_FIELD,
            START_RESPONSE_FIELD, UPDATE_RESPONSE_FIELD, TIMEOUT_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean active;

    private final FulfillmentStartResponseSpecification startResponse;

    private final FulfillmentUpdateResponseSpecification updateResponse;

    private final Integer timeoutInSeconds;

    private FulfillmentUpdatesSpecification(BuilderImpl builder) {
        this.active = builder.active;
        this.startResponse = builder.startResponse;
        this.updateResponse = builder.updateResponse;
        this.timeoutInSeconds = builder.timeoutInSeconds;
    }

    /**
     * <p>
     * Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
     * </p>
     * <p>
     * If the <code>active</code> field is set to true, the <code>startResponse</code>, <code>updateResponse</code>, and
     * <code>timeoutInSeconds</code> fields are required.
     * </p>
     * 
     * @return Determines whether fulfillment updates are sent to the user. When this field is true, updates are
     *         sent.</p>
     *         <p>
     *         If the <code>active</code> field is set to true, the <code>startResponse</code>,
     *         <code>updateResponse</code>, and <code>timeoutInSeconds</code> fields are required.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * <p>
     * Provides configuration information for the message sent to users when the fulfillment Lambda functions starts
     * running.
     * </p>
     * 
     * @return Provides configuration information for the message sent to users when the fulfillment Lambda functions
     *         starts running.
     */
    public final FulfillmentStartResponseSpecification startResponse() {
        return startResponse;
    }

    /**
     * <p>
     * Provides configuration information for messages sent periodically to the user while the fulfillment Lambda
     * function is running.
     * </p>
     * 
     * @return Provides configuration information for messages sent periodically to the user while the fulfillment
     *         Lambda function is running.
     */
    public final FulfillmentUpdateResponseSpecification updateResponse() {
        return updateResponse;
    }

    /**
     * <p>
     * The length of time that the fulfillment Lambda function should run before it times out.
     * </p>
     * 
     * @return The length of time that the fulfillment Lambda function should run before it times out.
     */
    public final Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(startResponse());
        hashCode = 31 * hashCode + Objects.hashCode(updateResponse());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentUpdatesSpecification)) {
            return false;
        }
        FulfillmentUpdatesSpecification other = (FulfillmentUpdatesSpecification) obj;
        return Objects.equals(active(), other.active()) && Objects.equals(startResponse(), other.startResponse())
                && Objects.equals(updateResponse(), other.updateResponse())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FulfillmentUpdatesSpecification").add("Active", active()).add("StartResponse", startResponse())
                .add("UpdateResponse", updateResponse()).add("TimeoutInSeconds", timeoutInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        case "startResponse":
            return Optional.ofNullable(clazz.cast(startResponse()));
        case "updateResponse":
            return Optional.ofNullable(clazz.cast(updateResponse()));
        case "timeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FulfillmentUpdatesSpecification, T> g) {
        return obj -> g.apply((FulfillmentUpdatesSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FulfillmentUpdatesSpecification> {
        /**
         * <p>
         * Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
         * </p>
         * <p>
         * If the <code>active</code> field is set to true, the <code>startResponse</code>, <code>updateResponse</code>,
         * and <code>timeoutInSeconds</code> fields are required.
         * </p>
         * 
         * @param active
         *        Determines whether fulfillment updates are sent to the user. When this field is true, updates are
         *        sent.</p>
         *        <p>
         *        If the <code>active</code> field is set to true, the <code>startResponse</code>,
         *        <code>updateResponse</code>, and <code>timeoutInSeconds</code> fields are required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * Provides configuration information for the message sent to users when the fulfillment Lambda functions starts
         * running.
         * </p>
         * 
         * @param startResponse
         *        Provides configuration information for the message sent to users when the fulfillment Lambda functions
         *        starts running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startResponse(FulfillmentStartResponseSpecification startResponse);

        /**
         * <p>
         * Provides configuration information for the message sent to users when the fulfillment Lambda functions starts
         * running.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FulfillmentStartResponseSpecification.Builder} avoiding the need to create one manually via
         * {@link FulfillmentStartResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FulfillmentStartResponseSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #startResponse(FulfillmentStartResponseSpecification)}.
         * 
         * @param startResponse
         *        a consumer that will call methods on {@link FulfillmentStartResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startResponse(FulfillmentStartResponseSpecification)
         */
        default Builder startResponse(Consumer<FulfillmentStartResponseSpecification.Builder> startResponse) {
            return startResponse(FulfillmentStartResponseSpecification.builder().applyMutation(startResponse).build());
        }

        /**
         * <p>
         * Provides configuration information for messages sent periodically to the user while the fulfillment Lambda
         * function is running.
         * </p>
         * 
         * @param updateResponse
         *        Provides configuration information for messages sent periodically to the user while the fulfillment
         *        Lambda function is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateResponse(FulfillmentUpdateResponseSpecification updateResponse);

        /**
         * <p>
         * Provides configuration information for messages sent periodically to the user while the fulfillment Lambda
         * function is running.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FulfillmentUpdateResponseSpecification.Builder} avoiding the need to create one manually via
         * {@link FulfillmentUpdateResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FulfillmentUpdateResponseSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #updateResponse(FulfillmentUpdateResponseSpecification)}.
         * 
         * @param updateResponse
         *        a consumer that will call methods on {@link FulfillmentUpdateResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateResponse(FulfillmentUpdateResponseSpecification)
         */
        default Builder updateResponse(Consumer<FulfillmentUpdateResponseSpecification.Builder> updateResponse) {
            return updateResponse(FulfillmentUpdateResponseSpecification.builder().applyMutation(updateResponse).build());
        }

        /**
         * <p>
         * The length of time that the fulfillment Lambda function should run before it times out.
         * </p>
         * 
         * @param timeoutInSeconds
         *        The length of time that the fulfillment Lambda function should run before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Boolean active;

        private FulfillmentStartResponseSpecification startResponse;

        private FulfillmentUpdateResponseSpecification updateResponse;

        private Integer timeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentUpdatesSpecification model) {
            active(model.active);
            startResponse(model.startResponse);
            updateResponse(model.updateResponse);
            timeoutInSeconds(model.timeoutInSeconds);
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final FulfillmentStartResponseSpecification.Builder getStartResponse() {
            return startResponse != null ? startResponse.toBuilder() : null;
        }

        public final void setStartResponse(FulfillmentStartResponseSpecification.BuilderImpl startResponse) {
            this.startResponse = startResponse != null ? startResponse.build() : null;
        }

        @Override
        public final Builder startResponse(FulfillmentStartResponseSpecification startResponse) {
            this.startResponse = startResponse;
            return this;
        }

        public final FulfillmentUpdateResponseSpecification.Builder getUpdateResponse() {
            return updateResponse != null ? updateResponse.toBuilder() : null;
        }

        public final void setUpdateResponse(FulfillmentUpdateResponseSpecification.BuilderImpl updateResponse) {
            this.updateResponse = updateResponse != null ? updateResponse.build() : null;
        }

        @Override
        public final Builder updateResponse(FulfillmentUpdateResponseSpecification updateResponse) {
            this.updateResponse = updateResponse;
            return this;
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        @Override
        public FulfillmentUpdatesSpecification build() {
            return new FulfillmentUpdatesSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
