/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTestExecutionResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeTestExecutionResponse.Builder, DescribeTestExecutionResponse> {
    private static final SdkField<String> TEST_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionId").getter(getter(DescribeTestExecutionResponse::testExecutionId))
            .setter(setter(Builder::testExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeTestExecutionResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeTestExecutionResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> TEST_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionStatus").getter(getter(DescribeTestExecutionResponse::testExecutionStatusAsString))
            .setter(setter(Builder::testExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionStatus").build())
            .build();

    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetId").getter(getter(DescribeTestExecutionResponse::testSetId)).setter(setter(Builder::testSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()).build();

    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetName").getter(getter(DescribeTestExecutionResponse::testSetName))
            .setter(setter(Builder::testSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()).build();

    private static final SdkField<TestExecutionTarget> TARGET_FIELD = SdkField
            .<TestExecutionTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(DescribeTestExecutionResponse::target)).setter(setter(Builder::target))
            .constructor(TestExecutionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> API_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiMode").getter(getter(DescribeTestExecutionResponse::apiModeAsString))
            .setter(setter(Builder::apiMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMode").build()).build();

    private static final SdkField<String> TEST_EXECUTION_MODALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionModality").getter(getter(DescribeTestExecutionResponse::testExecutionModalityAsString))
            .setter(setter(Builder::testExecutionModality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionModality").build())
            .build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeTestExecutionResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTION_ID_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, TEST_EXECUTION_STATUS_FIELD, TEST_SET_ID_FIELD,
            TEST_SET_NAME_FIELD, TARGET_FIELD, API_MODE_FIELD, TEST_EXECUTION_MODALITY_FIELD, FAILURE_REASONS_FIELD));

    private final String testExecutionId;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String testExecutionStatus;

    private final String testSetId;

    private final String testSetName;

    private final TestExecutionTarget target;

    private final String apiMode;

    private final String testExecutionModality;

    private final List<String> failureReasons;

    private DescribeTestExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.testExecutionId = builder.testExecutionId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.testExecutionStatus = builder.testExecutionStatus;
        this.testSetId = builder.testSetId;
        this.testSetName = builder.testSetName;
        this.target = builder.target;
        this.apiMode = builder.apiMode;
        this.testExecutionModality = builder.testExecutionModality;
        this.failureReasons = builder.failureReasons;
    }

    /**
     * <p>
     * The execution Id for the test set execution.
     * </p>
     * 
     * @return The execution Id for the test set execution.
     */
    public final String testExecutionId() {
        return testExecutionId;
    }

    /**
     * <p>
     * The execution creation date and time for the test set execution.
     * </p>
     * 
     * @return The execution creation date and time for the test set execution.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time of the last update for the execution.
     * </p>
     * 
     * @return The date and time of the last update for the execution.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The test execution status for the test execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionStatus} will return {@link TestExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionStatusAsString}.
     * </p>
     * 
     * @return The test execution status for the test execution.
     * @see TestExecutionStatus
     */
    public final TestExecutionStatus testExecutionStatus() {
        return TestExecutionStatus.fromValue(testExecutionStatus);
    }

    /**
     * <p>
     * The test execution status for the test execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionStatus} will return {@link TestExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionStatusAsString}.
     * </p>
     * 
     * @return The test execution status for the test execution.
     * @see TestExecutionStatus
     */
    public final String testExecutionStatusAsString() {
        return testExecutionStatus;
    }

    /**
     * <p>
     * The test set Id for the test set execution.
     * </p>
     * 
     * @return The test set Id for the test set execution.
     */
    public final String testSetId() {
        return testSetId;
    }

    /**
     * <p>
     * The test set name of the test set execution.
     * </p>
     * 
     * @return The test set name of the test set execution.
     */
    public final String testSetName() {
        return testSetName;
    }

    /**
     * <p>
     * The target bot for the test set execution details.
     * </p>
     * 
     * @return The target bot for the test set execution details.
     */
    public final TestExecutionTarget target() {
        return target;
    }

    /**
     * <p>
     * Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For streaming,
     * <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming,
     * <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiMode} will
     * return {@link TestExecutionApiMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #apiModeAsString}.
     * </p>
     * 
     * @return Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For
     *         streaming, <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming,
     *         <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.
     * @see TestExecutionApiMode
     */
    public final TestExecutionApiMode apiMode() {
        return TestExecutionApiMode.fromValue(apiMode);
    }

    /**
     * <p>
     * Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For streaming,
     * <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming,
     * <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiMode} will
     * return {@link TestExecutionApiMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #apiModeAsString}.
     * </p>
     * 
     * @return Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For
     *         streaming, <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming,
     *         <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.
     * @see TestExecutionApiMode
     */
    public final String apiModeAsString() {
        return apiMode;
    }

    /**
     * <p>
     * Indicates whether test set is audio or text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionModality} will return {@link TestExecutionModality#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionModalityAsString}.
     * </p>
     * 
     * @return Indicates whether test set is audio or text.
     * @see TestExecutionModality
     */
    public final TestExecutionModality testExecutionModality() {
        return TestExecutionModality.fromValue(testExecutionModality);
    }

    /**
     * <p>
     * Indicates whether test set is audio or text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionModality} will return {@link TestExecutionModality#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionModalityAsString}.
     * </p>
     * 
     * @return Indicates whether test set is audio or text.
     * @see TestExecutionModality
     */
    public final String testExecutionModalityAsString() {
        return testExecutionModality;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Reasons for the failure of the test set execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return Reasons for the failure of the test set execution.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(apiModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionModalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestExecutionResponse)) {
            return false;
        }
        DescribeTestExecutionResponse other = (DescribeTestExecutionResponse) obj;
        return Objects.equals(testExecutionId(), other.testExecutionId())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(testExecutionStatusAsString(), other.testExecutionStatusAsString())
                && Objects.equals(testSetId(), other.testSetId()) && Objects.equals(testSetName(), other.testSetName())
                && Objects.equals(target(), other.target()) && Objects.equals(apiModeAsString(), other.apiModeAsString())
                && Objects.equals(testExecutionModalityAsString(), other.testExecutionModalityAsString())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTestExecutionResponse").add("TestExecutionId", testExecutionId())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("TestExecutionStatus", testExecutionStatusAsString()).add("TestSetId", testSetId())
                .add("TestSetName", testSetName()).add("Target", target()).add("ApiMode", apiModeAsString())
                .add("TestExecutionModality", testExecutionModalityAsString())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testExecutionId":
            return Optional.ofNullable(clazz.cast(testExecutionId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "testExecutionStatus":
            return Optional.ofNullable(clazz.cast(testExecutionStatusAsString()));
        case "testSetId":
            return Optional.ofNullable(clazz.cast(testSetId()));
        case "testSetName":
            return Optional.ofNullable(clazz.cast(testSetName()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "apiMode":
            return Optional.ofNullable(clazz.cast(apiModeAsString()));
        case "testExecutionModality":
            return Optional.ofNullable(clazz.cast(testExecutionModalityAsString()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestExecutionResponse, T> g) {
        return obj -> g.apply((DescribeTestExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTestExecutionResponse> {
        /**
         * <p>
         * The execution Id for the test set execution.
         * </p>
         * 
         * @param testExecutionId
         *        The execution Id for the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testExecutionId(String testExecutionId);

        /**
         * <p>
         * The execution creation date and time for the test set execution.
         * </p>
         * 
         * @param creationDateTime
         *        The execution creation date and time for the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time of the last update for the execution.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time of the last update for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The test execution status for the test execution.
         * </p>
         * 
         * @param testExecutionStatus
         *        The test execution status for the test execution.
         * @see TestExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionStatus
         */
        Builder testExecutionStatus(String testExecutionStatus);

        /**
         * <p>
         * The test execution status for the test execution.
         * </p>
         * 
         * @param testExecutionStatus
         *        The test execution status for the test execution.
         * @see TestExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionStatus
         */
        Builder testExecutionStatus(TestExecutionStatus testExecutionStatus);

        /**
         * <p>
         * The test set Id for the test set execution.
         * </p>
         * 
         * @param testSetId
         *        The test set Id for the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetId(String testSetId);

        /**
         * <p>
         * The test set name of the test set execution.
         * </p>
         * 
         * @param testSetName
         *        The test set name of the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetName(String testSetName);

        /**
         * <p>
         * The target bot for the test set execution details.
         * </p>
         * 
         * @param target
         *        The target bot for the test set execution details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(TestExecutionTarget target);

        /**
         * <p>
         * The target bot for the test set execution details.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestExecutionTarget.Builder} avoiding the
         * need to create one manually via {@link TestExecutionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestExecutionTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #target(TestExecutionTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link TestExecutionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(TestExecutionTarget)
         */
        default Builder target(Consumer<TestExecutionTarget.Builder> target) {
            return target(TestExecutionTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For streaming,
         * <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming,
         * <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.
         * </p>
         * 
         * @param apiMode
         *        Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For
         *        streaming, <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming,
         *        <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.
         * @see TestExecutionApiMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionApiMode
         */
        Builder apiMode(String apiMode);

        /**
         * <p>
         * Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For streaming,
         * <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming,
         * <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.
         * </p>
         * 
         * @param apiMode
         *        Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For
         *        streaming, <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming,
         *        <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.
         * @see TestExecutionApiMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionApiMode
         */
        Builder apiMode(TestExecutionApiMode apiMode);

        /**
         * <p>
         * Indicates whether test set is audio or text.
         * </p>
         * 
         * @param testExecutionModality
         *        Indicates whether test set is audio or text.
         * @see TestExecutionModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionModality
         */
        Builder testExecutionModality(String testExecutionModality);

        /**
         * <p>
         * Indicates whether test set is audio or text.
         * </p>
         * 
         * @param testExecutionModality
         *        Indicates whether test set is audio or text.
         * @see TestExecutionModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionModality
         */
        Builder testExecutionModality(TestExecutionModality testExecutionModality);

        /**
         * <p>
         * Reasons for the failure of the test set execution.
         * </p>
         * 
         * @param failureReasons
         *        Reasons for the failure of the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * Reasons for the failure of the test set execution.
         * </p>
         * 
         * @param failureReasons
         *        Reasons for the failure of the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String testExecutionId;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String testExecutionStatus;

        private String testSetId;

        private String testSetName;

        private TestExecutionTarget target;

        private String apiMode;

        private String testExecutionModality;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestExecutionResponse model) {
            super(model);
            testExecutionId(model.testExecutionId);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            testExecutionStatus(model.testExecutionStatus);
            testSetId(model.testSetId);
            testSetName(model.testSetName);
            target(model.target);
            apiMode(model.apiMode);
            testExecutionModality(model.testExecutionModality);
            failureReasons(model.failureReasons);
        }

        public final String getTestExecutionId() {
            return testExecutionId;
        }

        public final void setTestExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
        }

        @Override
        public final Builder testExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getTestExecutionStatus() {
            return testExecutionStatus;
        }

        public final void setTestExecutionStatus(String testExecutionStatus) {
            this.testExecutionStatus = testExecutionStatus;
        }

        @Override
        public final Builder testExecutionStatus(String testExecutionStatus) {
            this.testExecutionStatus = testExecutionStatus;
            return this;
        }

        @Override
        public final Builder testExecutionStatus(TestExecutionStatus testExecutionStatus) {
            this.testExecutionStatus(testExecutionStatus == null ? null : testExecutionStatus.toString());
            return this;
        }

        public final String getTestSetId() {
            return testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final String getTestSetName() {
            return testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final TestExecutionTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(TestExecutionTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TestExecutionTarget target) {
            this.target = target;
            return this;
        }

        public final String getApiMode() {
            return apiMode;
        }

        public final void setApiMode(String apiMode) {
            this.apiMode = apiMode;
        }

        @Override
        public final Builder apiMode(String apiMode) {
            this.apiMode = apiMode;
            return this;
        }

        @Override
        public final Builder apiMode(TestExecutionApiMode apiMode) {
            this.apiMode(apiMode == null ? null : apiMode.toString());
            return this;
        }

        public final String getTestExecutionModality() {
            return testExecutionModality;
        }

        public final void setTestExecutionModality(String testExecutionModality) {
            this.testExecutionModality = testExecutionModality;
        }

        @Override
        public final Builder testExecutionModality(String testExecutionModality) {
            this.testExecutionModality = testExecutionModality;
            return this;
        }

        @Override
        public final Builder testExecutionModality(TestExecutionModality testExecutionModality) {
            this.testExecutionModality(testExecutionModality == null ? null : testExecutionModality.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        @Override
        public DescribeTestExecutionResponse build() {
            return new DescribeTestExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
