/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSlotRequest extends LexModelsV2Request implements
        ToCopyableBuilder<DescribeSlotRequest.Builder, DescribeSlotRequest> {
    private static final SdkField<String> SLOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("slotId")
            .getter(getter(DescribeSlotRequest::slotId)).setter(setter(Builder::slotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("slotId").build()).build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeSlotRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DescribeSlotRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(DescribeSlotRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(DescribeSlotRequest::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("intentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_ID_FIELD, BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, INTENT_ID_FIELD));

    private final String slotId;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String intentId;

    private DescribeSlotRequest(BuilderImpl builder) {
        super(builder);
        this.slotId = builder.slotId;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.intentId = builder.intentId;
    }

    /**
     * <p>
     * The unique identifier for the slot.
     * </p>
     * 
     * @return The unique identifier for the slot.
     */
    public final String slotId() {
        return slotId;
    }

    /**
     * <p>
     * The identifier of the bot associated with the slot.
     * </p>
     * 
     * @return The identifier of the bot associated with the slot.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot associated with the slot.
     * </p>
     * 
     * @return The version of the bot associated with the slot.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the slot to describe. The string must match one of the supported
     * locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale of the slot to describe. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The identifier of the intent that contains the slot.
     * </p>
     * 
     * @return The identifier of the intent that contains the slot.
     */
    public final String intentId() {
        return intentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slotId());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSlotRequest)) {
            return false;
        }
        DescribeSlotRequest other = (DescribeSlotRequest) obj;
        return Objects.equals(slotId(), other.slotId()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(intentId(), other.intentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSlotRequest").add("SlotId", slotId()).add("BotId", botId())
                .add("BotVersion", botVersion()).add("LocaleId", localeId()).add("IntentId", intentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotId":
            return Optional.ofNullable(clazz.cast(slotId()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSlotRequest, T> g) {
        return obj -> g.apply((DescribeSlotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSlotRequest> {
        /**
         * <p>
         * The unique identifier for the slot.
         * </p>
         * 
         * @param slotId
         *        The unique identifier for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotId(String slotId);

        /**
         * <p>
         * The identifier of the bot associated with the slot.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot associated with the slot.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the slot to describe. The string must match one of the supported
         * locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the slot to describe. The string must match one of the
         *        supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The identifier of the intent that contains the slot.
         * </p>
         * 
         * @param intentId
         *        The identifier of the intent that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String slotId;

        private String botId;

        private String botVersion;

        private String localeId;

        private String intentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSlotRequest model) {
            super(model);
            slotId(model.slotId);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            intentId(model.intentId);
        }

        public final String getSlotId() {
            return slotId;
        }

        public final void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        @Override
        public final Builder slotId(String slotId) {
            this.slotId = slotId;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getIntentId() {
            return intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSlotRequest build() {
            return new DescribeSlotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
