/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conversation level details of the conversation used in the test set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationLevelResultDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationLevelResultDetail.Builder, ConversationLevelResultDetail> {
    private static final SdkField<String> END_TO_END_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endToEndResult").getter(getter(ConversationLevelResultDetail::endToEndResultAsString))
            .setter(setter(Builder::endToEndResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endToEndResult").build()).build();

    private static final SdkField<String> SPEECH_TRANSCRIPTION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("speechTranscriptionResult")
            .getter(getter(ConversationLevelResultDetail::speechTranscriptionResultAsString))
            .setter(setter(Builder::speechTranscriptionResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TO_END_RESULT_FIELD,
            SPEECH_TRANSCRIPTION_RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endToEndResult;

    private final String speechTranscriptionResult;

    private ConversationLevelResultDetail(BuilderImpl builder) {
        this.endToEndResult = builder.endToEndResult;
        this.speechTranscriptionResult = builder.speechTranscriptionResult;
    }

    /**
     * <p>
     * The success or failure of the streaming of the conversation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endToEndResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endToEndResultAsString}.
     * </p>
     * 
     * @return The success or failure of the streaming of the conversation.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus endToEndResult() {
        return TestResultMatchStatus.fromValue(endToEndResult);
    }

    /**
     * <p>
     * The success or failure of the streaming of the conversation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endToEndResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endToEndResultAsString}.
     * </p>
     * 
     * @return The success or failure of the streaming of the conversation.
     * @see TestResultMatchStatus
     */
    public final String endToEndResultAsString() {
        return endToEndResult;
    }

    /**
     * <p>
     * The speech transcription success or failure details of the conversation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechTranscriptionResult} will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #speechTranscriptionResultAsString}.
     * </p>
     * 
     * @return The speech transcription success or failure details of the conversation.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus speechTranscriptionResult() {
        return TestResultMatchStatus.fromValue(speechTranscriptionResult);
    }

    /**
     * <p>
     * The speech transcription success or failure details of the conversation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechTranscriptionResult} will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #speechTranscriptionResultAsString}.
     * </p>
     * 
     * @return The speech transcription success or failure details of the conversation.
     * @see TestResultMatchStatus
     */
    public final String speechTranscriptionResultAsString() {
        return speechTranscriptionResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endToEndResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(speechTranscriptionResultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLevelResultDetail)) {
            return false;
        }
        ConversationLevelResultDetail other = (ConversationLevelResultDetail) obj;
        return Objects.equals(endToEndResultAsString(), other.endToEndResultAsString())
                && Objects.equals(speechTranscriptionResultAsString(), other.speechTranscriptionResultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationLevelResultDetail").add("EndToEndResult", endToEndResultAsString())
                .add("SpeechTranscriptionResult", speechTranscriptionResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endToEndResult":
            return Optional.ofNullable(clazz.cast(endToEndResultAsString()));
        case "speechTranscriptionResult":
            return Optional.ofNullable(clazz.cast(speechTranscriptionResultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLevelResultDetail, T> g) {
        return obj -> g.apply((ConversationLevelResultDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationLevelResultDetail> {
        /**
         * <p>
         * The success or failure of the streaming of the conversation.
         * </p>
         * 
         * @param endToEndResult
         *        The success or failure of the streaming of the conversation.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder endToEndResult(String endToEndResult);

        /**
         * <p>
         * The success or failure of the streaming of the conversation.
         * </p>
         * 
         * @param endToEndResult
         *        The success or failure of the streaming of the conversation.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder endToEndResult(TestResultMatchStatus endToEndResult);

        /**
         * <p>
         * The speech transcription success or failure details of the conversation.
         * </p>
         * 
         * @param speechTranscriptionResult
         *        The speech transcription success or failure details of the conversation.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder speechTranscriptionResult(String speechTranscriptionResult);

        /**
         * <p>
         * The speech transcription success or failure details of the conversation.
         * </p>
         * 
         * @param speechTranscriptionResult
         *        The speech transcription success or failure details of the conversation.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder speechTranscriptionResult(TestResultMatchStatus speechTranscriptionResult);
    }

    static final class BuilderImpl implements Builder {
        private String endToEndResult;

        private String speechTranscriptionResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLevelResultDetail model) {
            endToEndResult(model.endToEndResult);
            speechTranscriptionResult(model.speechTranscriptionResult);
        }

        public final String getEndToEndResult() {
            return endToEndResult;
        }

        public final void setEndToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
        }

        @Override
        public final Builder endToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
            return this;
        }

        @Override
        public final Builder endToEndResult(TestResultMatchStatus endToEndResult) {
            this.endToEndResult(endToEndResult == null ? null : endToEndResult.toString());
            return this;
        }

        public final String getSpeechTranscriptionResult() {
            return speechTranscriptionResult;
        }

        public final void setSpeechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
        }

        @Override
        public final Builder speechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
            return this;
        }

        @Override
        public final Builder speechTranscriptionResult(TestResultMatchStatus speechTranscriptionResult) {
            this.speechTranscriptionResult(speechTranscriptionResult == null ? null : speechTranscriptionResult.toString());
            return this;
        }

        @Override
        public ConversationLevelResultDetail build() {
            return new ConversationLevelResultDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
