/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon CloudWatch Logs log group where the text and metadata logs are delivered. The log group must exist before
 * you enable logging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogGroupLogDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogGroupLogDestination.Builder, CloudWatchLogGroupLogDestination> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudWatchLogGroupArn").getter(getter(CloudWatchLogGroupLogDestination::cloudWatchLogGroupArn))
            .setter(setter(Builder::cloudWatchLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogGroupArn").build())
            .build();

    private static final SdkField<String> LOG_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logPrefix").getter(getter(CloudWatchLogGroupLogDestination::logPrefix))
            .setter(setter(Builder::logPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOG_GROUP_ARN_FIELD, LOG_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogGroupArn;

    private final String logPrefix;

    private CloudWatchLogGroupLogDestination(BuilderImpl builder) {
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.logPrefix = builder.logPrefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.
     */
    public final String cloudWatchLogGroupArn() {
        return cloudWatchLogGroupArn;
    }

    /**
     * <p>
     * The prefix of the log stream name within the log group that you specified
     * </p>
     * 
     * @return The prefix of the log stream name within the log group that you specified
     */
    public final String logPrefix() {
        return logPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(logPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogGroupLogDestination)) {
            return false;
        }
        CloudWatchLogGroupLogDestination other = (CloudWatchLogGroupLogDestination) obj;
        return Objects.equals(cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn())
                && Objects.equals(logPrefix(), other.logPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLogGroupLogDestination").add("CloudWatchLogGroupArn", cloudWatchLogGroupArn())
                .add("LogPrefix", logPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupArn()));
        case "logPrefix":
            return Optional.ofNullable(clazz.cast(logPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogGroupLogDestination, T> g) {
        return obj -> g.apply((CloudWatchLogGroupLogDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogGroupLogDestination> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.
         * </p>
         * 
         * @param cloudWatchLogGroupArn
         *        The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn);

        /**
         * <p>
         * The prefix of the log stream name within the log group that you specified
         * </p>
         * 
         * @param logPrefix
         *        The prefix of the log stream name within the log group that you specified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPrefix(String logPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogGroupArn;

        private String logPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogGroupLogDestination model) {
            cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            logPrefix(model.logPrefix);
        }

        public final String getCloudWatchLogGroupArn() {
            return cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final String getLogPrefix() {
            return logPrefix;
        }

        public final void setLogPrefix(String logPrefix) {
            this.logPrefix = logPrefix;
        }

        @Override
        public final Builder logPrefix(String logPrefix) {
            this.logPrefix = logPrefix;
            return this;
        }

        @Override
        public CloudWatchLogGroupLogDestination build() {
            return new CloudWatchLogGroupLogDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
