/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResults;
import software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.EncryptionSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.TranscriptSourceSetting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBotRecommendationResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DescribeBotRecommendationResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::botId)).setter(DescribeBotRecommendationResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::botVersion)).setter(DescribeBotRecommendationResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::localeId)).setter(DescribeBotRecommendationResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> BOT_RECOMMENDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botRecommendationStatus").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::botRecommendationStatusAsString)).setter(DescribeBotRecommendationResponse.setter(Builder::botRecommendationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationStatus").build()}).build();
    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botRecommendationId").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::botRecommendationId)).setter(DescribeBotRecommendationResponse.setter(Builder::botRecommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationId").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::failureReasons)).setter(DescribeBotRecommendationResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::creationDateTime)).setter(DescribeBotRecommendationResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::lastUpdatedDateTime)).setter(DescribeBotRecommendationResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<TranscriptSourceSetting> TRANSCRIPT_SOURCE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transcriptSourceSetting").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::transcriptSourceSetting)).setter(DescribeBotRecommendationResponse.setter(Builder::transcriptSourceSetting)).constructor(TranscriptSourceSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcriptSourceSetting").build()}).build();
    private static final SdkField<EncryptionSetting> ENCRYPTION_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionSetting").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::encryptionSetting)).setter(DescribeBotRecommendationResponse.setter(Builder::encryptionSetting)).constructor(EncryptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSetting").build()}).build();
    private static final SdkField<BotRecommendationResults> BOT_RECOMMENDATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("botRecommendationResults").getter(DescribeBotRecommendationResponse.getter(DescribeBotRecommendationResponse::botRecommendationResults)).setter(DescribeBotRecommendationResponse.setter(Builder::botRecommendationResults)).constructor(BotRecommendationResults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_STATUS_FIELD, BOT_RECOMMENDATION_ID_FIELD, FAILURE_REASONS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, TRANSCRIPT_SOURCE_SETTING_FIELD, ENCRYPTION_SETTING_FIELD, BOT_RECOMMENDATION_RESULTS_FIELD));
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String botRecommendationStatus;
    private final String botRecommendationId;
    private final List<String> failureReasons;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final TranscriptSourceSetting transcriptSourceSetting;
    private final EncryptionSetting encryptionSetting;
    private final BotRecommendationResults botRecommendationResults;

    private DescribeBotRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationStatus = builder.botRecommendationStatus;
        this.botRecommendationId = builder.botRecommendationId;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.transcriptSourceSetting = builder.transcriptSourceSetting;
        this.encryptionSetting = builder.encryptionSetting;
        this.botRecommendationResults = builder.botRecommendationResults;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final BotRecommendationStatus botRecommendationStatus() {
        return BotRecommendationStatus.fromValue(this.botRecommendationStatus);
    }

    public final String botRecommendationStatusAsString() {
        return this.botRecommendationStatus;
    }

    public final String botRecommendationId() {
        return this.botRecommendationId;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final TranscriptSourceSetting transcriptSourceSetting() {
        return this.transcriptSourceSetting;
    }

    public final EncryptionSetting encryptionSetting() {
        return this.encryptionSetting;
    }

    public final BotRecommendationResults botRecommendationResults() {
        return this.botRecommendationResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botRecommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.botRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptSourceSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.botRecommendationResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotRecommendationResponse)) {
            return false;
        }
        DescribeBotRecommendationResponse other = (DescribeBotRecommendationResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.botRecommendationStatusAsString(), other.botRecommendationStatusAsString()) && Objects.equals(this.botRecommendationId(), other.botRecommendationId()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.transcriptSourceSetting(), other.transcriptSourceSetting()) && Objects.equals(this.encryptionSetting(), other.encryptionSetting()) && Objects.equals(this.botRecommendationResults(), other.botRecommendationResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBotRecommendationResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("BotRecommendationStatus", (Object)this.botRecommendationStatusAsString()).add("BotRecommendationId", (Object)this.botRecommendationId()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("TranscriptSourceSetting", (Object)this.transcriptSourceSetting()).add("EncryptionSetting", (Object)this.encryptionSetting()).add("BotRecommendationResults", (Object)this.botRecommendationResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "botRecommendationStatus": {
                return Optional.ofNullable(clazz.cast(this.botRecommendationStatusAsString()));
            }
            case "botRecommendationId": {
                return Optional.ofNullable(clazz.cast(this.botRecommendationId()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "transcriptSourceSetting": {
                return Optional.ofNullable(clazz.cast(this.transcriptSourceSetting()));
            }
            case "encryptionSetting": {
                return Optional.ofNullable(clazz.cast(this.encryptionSetting()));
            }
            case "botRecommendationResults": {
                return Optional.ofNullable(clazz.cast(this.botRecommendationResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotRecommendationResponse, T> g) {
        return obj -> g.apply((DescribeBotRecommendationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String botRecommendationStatus;
        private String botRecommendationId;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private TranscriptSourceSetting transcriptSourceSetting;
        private EncryptionSetting encryptionSetting;
        private BotRecommendationResults botRecommendationResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotRecommendationResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.botRecommendationStatus(model.botRecommendationStatus);
            this.botRecommendationId(model.botRecommendationId);
            this.failureReasons(model.failureReasons);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.transcriptSourceSetting(model.transcriptSourceSetting);
            this.encryptionSetting(model.encryptionSetting);
            this.botRecommendationResults(model.botRecommendationResults);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotRecommendationStatus() {
            return this.botRecommendationStatus;
        }

        public final void setBotRecommendationStatus(String botRecommendationStatus) {
            this.botRecommendationStatus = botRecommendationStatus;
        }

        @Override
        public final Builder botRecommendationStatus(String botRecommendationStatus) {
            this.botRecommendationStatus = botRecommendationStatus;
            return this;
        }

        @Override
        public final Builder botRecommendationStatus(BotRecommendationStatus botRecommendationStatus) {
            this.botRecommendationStatus(botRecommendationStatus == null ? null : botRecommendationStatus.toString());
            return this;
        }

        public final String getBotRecommendationId() {
            return this.botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final TranscriptSourceSetting.Builder getTranscriptSourceSetting() {
            return this.transcriptSourceSetting != null ? this.transcriptSourceSetting.toBuilder() : null;
        }

        public final void setTranscriptSourceSetting(TranscriptSourceSetting.BuilderImpl transcriptSourceSetting) {
            this.transcriptSourceSetting = transcriptSourceSetting != null ? transcriptSourceSetting.build() : null;
        }

        @Override
        public final Builder transcriptSourceSetting(TranscriptSourceSetting transcriptSourceSetting) {
            this.transcriptSourceSetting = transcriptSourceSetting;
            return this;
        }

        public final EncryptionSetting.Builder getEncryptionSetting() {
            return this.encryptionSetting != null ? this.encryptionSetting.toBuilder() : null;
        }

        public final void setEncryptionSetting(EncryptionSetting.BuilderImpl encryptionSetting) {
            this.encryptionSetting = encryptionSetting != null ? encryptionSetting.build() : null;
        }

        @Override
        public final Builder encryptionSetting(EncryptionSetting encryptionSetting) {
            this.encryptionSetting = encryptionSetting;
            return this;
        }

        public final BotRecommendationResults.Builder getBotRecommendationResults() {
            return this.botRecommendationResults != null ? this.botRecommendationResults.toBuilder() : null;
        }

        public final void setBotRecommendationResults(BotRecommendationResults.BuilderImpl botRecommendationResults) {
            this.botRecommendationResults = botRecommendationResults != null ? botRecommendationResults.build() : null;
        }

        @Override
        public final Builder botRecommendationResults(BotRecommendationResults botRecommendationResults) {
            this.botRecommendationResults = botRecommendationResults;
            return this;
        }

        @Override
        public DescribeBotRecommendationResponse build() {
            return new DescribeBotRecommendationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBotRecommendationResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder botRecommendationStatus(String var1);

        public Builder botRecommendationStatus(BotRecommendationStatus var1);

        public Builder botRecommendationId(String var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder transcriptSourceSetting(TranscriptSourceSetting var1);

        default public Builder transcriptSourceSetting(Consumer<TranscriptSourceSetting.Builder> transcriptSourceSetting) {
            return this.transcriptSourceSetting((TranscriptSourceSetting)((TranscriptSourceSetting.Builder)TranscriptSourceSetting.builder().applyMutation(transcriptSourceSetting)).build());
        }

        public Builder encryptionSetting(EncryptionSetting var1);

        default public Builder encryptionSetting(Consumer<EncryptionSetting.Builder> encryptionSetting) {
            return this.encryptionSetting((EncryptionSetting)((EncryptionSetting.Builder)EncryptionSetting.builder().applyMutation(encryptionSetting)).build());
        }

        public Builder botRecommendationResults(BotRecommendationResults var1);

        default public Builder botRecommendationResults(Consumer<BotRecommendationResults.Builder> botRecommendationResults) {
            return this.botRecommendationResults((BotRecommendationResults)((BotRecommendationResults.Builder)BotRecommendationResults.builder().applyMutation(botRecommendationResults)).build());
        }
    }
}

