/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;

public class ListBuiltInSlotTypesPublisher
implements SdkPublisher<ListBuiltInSlotTypesResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListBuiltInSlotTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBuiltInSlotTypesPublisher(LexModelsV2AsyncClient client, ListBuiltInSlotTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBuiltInSlotTypesPublisher(LexModelsV2AsyncClient client, ListBuiltInSlotTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBuiltInSlotTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBuiltInSlotTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBuiltInSlotTypesResponseFetcher
    implements AsyncPageFetcher<ListBuiltInSlotTypesResponse> {
        private ListBuiltInSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListBuiltInSlotTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBuiltInSlotTypesResponse> nextPage(ListBuiltInSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return ListBuiltInSlotTypesPublisher.this.client.listBuiltInSlotTypes(ListBuiltInSlotTypesPublisher.this.firstRequest);
            }
            return ListBuiltInSlotTypesPublisher.this.client.listBuiltInSlotTypes((ListBuiltInSlotTypesRequest)((Object)ListBuiltInSlotTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

