/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotAliasesResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBotAliasesResponse> {
    private static final SdkField<List<BotAliasSummary>> BOT_ALIAS_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botAliasSummaries").getter(ListBotAliasesResponse.getter(ListBotAliasesResponse::botAliasSummaries)).setter(ListBotAliasesResponse.setter(Builder::botAliasSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotAliasSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotAliasesResponse.getter(ListBotAliasesResponse::nextToken)).setter(ListBotAliasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotAliasesResponse.getter(ListBotAliasesResponse::botId)).setter(ListBotAliasesResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, BOT_ID_FIELD));
    private final List<BotAliasSummary> botAliasSummaries;
    private final String nextToken;
    private final String botId;

    private ListBotAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.botAliasSummaries = builder.botAliasSummaries;
        this.nextToken = builder.nextToken;
        this.botId = builder.botId;
    }

    public final boolean hasBotAliasSummaries() {
        return this.botAliasSummaries != null && !(this.botAliasSummaries instanceof SdkAutoConstructList);
    }

    public final List<BotAliasSummary> botAliasSummaries() {
        return this.botAliasSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotAliasSummaries() ? this.botAliasSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotAliasesResponse)) {
            return false;
        }
        ListBotAliasesResponse other = (ListBotAliasesResponse)((Object)obj);
        return this.hasBotAliasSummaries() == other.hasBotAliasSummaries() && Objects.equals(this.botAliasSummaries(), other.botAliasSummaries()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.botId(), other.botId());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotAliasesResponse").add("BotAliasSummaries", this.hasBotAliasSummaries() ? this.botAliasSummaries() : null).add("NextToken", (Object)this.nextToken()).add("BotId", (Object)this.botId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botAliasSummaries": {
                return Optional.ofNullable(clazz.cast(this.botAliasSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotAliasesResponse, T> g) {
        return obj -> g.apply((ListBotAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private List<BotAliasSummary> botAliasSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String botId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotAliasesResponse model) {
            super(model);
            this.botAliasSummaries(model.botAliasSummaries);
            this.nextToken(model.nextToken);
            this.botId(model.botId);
        }

        public final List<BotAliasSummary.Builder> getBotAliasSummaries() {
            List<BotAliasSummary.Builder> result = BotAliasSummaryListCopier.copyToBuilder(this.botAliasSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotAliasSummaries(Collection<BotAliasSummary.BuilderImpl> botAliasSummaries) {
            this.botAliasSummaries = BotAliasSummaryListCopier.copyFromBuilder(botAliasSummaries);
        }

        @Override
        public final Builder botAliasSummaries(Collection<BotAliasSummary> botAliasSummaries) {
            this.botAliasSummaries = BotAliasSummaryListCopier.copy(botAliasSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliasSummaries(BotAliasSummary ... botAliasSummaries) {
            this.botAliasSummaries(Arrays.asList(botAliasSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliasSummaries(Consumer<BotAliasSummary.Builder> ... botAliasSummaries) {
            this.botAliasSummaries(Stream.of(botAliasSummaries).map(c -> (BotAliasSummary)((BotAliasSummary.Builder)BotAliasSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        @Override
        public ListBotAliasesResponse build() {
            return new ListBotAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotAliasesResponse> {
        public Builder botAliasSummaries(Collection<BotAliasSummary> var1);

        public Builder botAliasSummaries(BotAliasSummary ... var1);

        public Builder botAliasSummaries(Consumer<BotAliasSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder botId(String var1);
    }
}

