/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.TagMapCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportInputLocation;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestSetImportResourceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestSetImportResourceSpecification> {
    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetName").getter(TestSetImportResourceSpecification.getter(TestSetImportResourceSpecification::testSetName)).setter(TestSetImportResourceSpecification.setter(Builder::testSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(TestSetImportResourceSpecification.getter(TestSetImportResourceSpecification::description)).setter(TestSetImportResourceSpecification.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(TestSetImportResourceSpecification.getter(TestSetImportResourceSpecification::roleArn)).setter(TestSetImportResourceSpecification.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<TestSetStorageLocation> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageLocation").getter(TestSetImportResourceSpecification.getter(TestSetImportResourceSpecification::storageLocation)).setter(TestSetImportResourceSpecification.setter(Builder::storageLocation)).constructor(TestSetStorageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()}).build();
    private static final SdkField<TestSetImportInputLocation> IMPORT_INPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importInputLocation").getter(TestSetImportResourceSpecification.getter(TestSetImportResourceSpecification::importInputLocation)).setter(TestSetImportResourceSpecification.setter(Builder::importInputLocation)).constructor(TestSetImportInputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importInputLocation").build()}).build();
    private static final SdkField<String> MODALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modality").getter(TestSetImportResourceSpecification.getter(TestSetImportResourceSpecification::modalityAsString)).setter(TestSetImportResourceSpecification.setter(Builder::modality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modality").build()}).build();
    private static final SdkField<Map<String, String>> TEST_SET_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("testSetTags").getter(TestSetImportResourceSpecification.getter(TestSetImportResourceSpecification::testSetTags)).setter(TestSetImportResourceSpecification.setter(Builder::testSetTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, STORAGE_LOCATION_FIELD, IMPORT_INPUT_LOCATION_FIELD, MODALITY_FIELD, TEST_SET_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String testSetName;
    private final String description;
    private final String roleArn;
    private final TestSetStorageLocation storageLocation;
    private final TestSetImportInputLocation importInputLocation;
    private final String modality;
    private final Map<String, String> testSetTags;

    private TestSetImportResourceSpecification(BuilderImpl builder) {
        this.testSetName = builder.testSetName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.storageLocation = builder.storageLocation;
        this.importInputLocation = builder.importInputLocation;
        this.modality = builder.modality;
        this.testSetTags = builder.testSetTags;
    }

    public final String testSetName() {
        return this.testSetName;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final TestSetStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public final TestSetImportInputLocation importInputLocation() {
        return this.importInputLocation;
    }

    public final TestSetModality modality() {
        return TestSetModality.fromValue(this.modality);
    }

    public final String modalityAsString() {
        return this.modality;
    }

    public final boolean hasTestSetTags() {
        return this.testSetTags != null && !(this.testSetTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> testSetTags() {
        return this.testSetTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.importInputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.modalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestSetTags() ? this.testSetTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSetImportResourceSpecification)) {
            return false;
        }
        TestSetImportResourceSpecification other = (TestSetImportResourceSpecification)obj;
        return Objects.equals(this.testSetName(), other.testSetName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.storageLocation(), other.storageLocation()) && Objects.equals(this.importInputLocation(), other.importInputLocation()) && Objects.equals(this.modalityAsString(), other.modalityAsString()) && this.hasTestSetTags() == other.hasTestSetTags() && Objects.equals(this.testSetTags(), other.testSetTags());
    }

    public final String toString() {
        return ToString.builder((String)"TestSetImportResourceSpecification").add("TestSetName", (Object)this.testSetName()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("StorageLocation", (Object)this.storageLocation()).add("ImportInputLocation", (Object)this.importInputLocation()).add("Modality", (Object)this.modalityAsString()).add("TestSetTags", this.hasTestSetTags() ? this.testSetTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSetName": {
                return Optional.ofNullable(clazz.cast(this.testSetName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "storageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
            case "importInputLocation": {
                return Optional.ofNullable(clazz.cast(this.importInputLocation()));
            }
            case "modality": {
                return Optional.ofNullable(clazz.cast(this.modalityAsString()));
            }
            case "testSetTags": {
                return Optional.ofNullable(clazz.cast(this.testSetTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestSetImportResourceSpecification, T> g) {
        return obj -> g.apply((TestSetImportResourceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String testSetName;
        private String description;
        private String roleArn;
        private TestSetStorageLocation storageLocation;
        private TestSetImportInputLocation importInputLocation;
        private String modality;
        private Map<String, String> testSetTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestSetImportResourceSpecification model) {
            this.testSetName(model.testSetName);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.storageLocation(model.storageLocation);
            this.importInputLocation(model.importInputLocation);
            this.modality(model.modality);
            this.testSetTags(model.testSetTags);
        }

        public final String getTestSetName() {
            return this.testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final TestSetStorageLocation.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(TestSetStorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(TestSetStorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final TestSetImportInputLocation.Builder getImportInputLocation() {
            return this.importInputLocation != null ? this.importInputLocation.toBuilder() : null;
        }

        public final void setImportInputLocation(TestSetImportInputLocation.BuilderImpl importInputLocation) {
            this.importInputLocation = importInputLocation != null ? importInputLocation.build() : null;
        }

        @Override
        public final Builder importInputLocation(TestSetImportInputLocation importInputLocation) {
            this.importInputLocation = importInputLocation;
            return this;
        }

        public final String getModality() {
            return this.modality;
        }

        public final void setModality(String modality) {
            this.modality = modality;
        }

        @Override
        public final Builder modality(String modality) {
            this.modality = modality;
            return this;
        }

        @Override
        public final Builder modality(TestSetModality modality) {
            this.modality(modality == null ? null : modality.toString());
            return this;
        }

        public final Map<String, String> getTestSetTags() {
            if (this.testSetTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.testSetTags;
        }

        public final void setTestSetTags(Map<String, String> testSetTags) {
            this.testSetTags = TagMapCopier.copy(testSetTags);
        }

        @Override
        public final Builder testSetTags(Map<String, String> testSetTags) {
            this.testSetTags = TagMapCopier.copy(testSetTags);
            return this;
        }

        public TestSetImportResourceSpecification build() {
            return new TestSetImportResourceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestSetImportResourceSpecification> {
        public Builder testSetName(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder storageLocation(TestSetStorageLocation var1);

        default public Builder storageLocation(Consumer<TestSetStorageLocation.Builder> storageLocation) {
            return this.storageLocation((TestSetStorageLocation)((TestSetStorageLocation.Builder)TestSetStorageLocation.builder().applyMutation(storageLocation)).build());
        }

        public Builder importInputLocation(TestSetImportInputLocation var1);

        default public Builder importInputLocation(Consumer<TestSetImportInputLocation.Builder> importInputLocation) {
            return this.importInputLocation((TestSetImportInputLocation)((TestSetImportInputLocation.Builder)TestSetImportInputLocation.builder().applyMutation(importInputLocation)).build());
        }

        public Builder modality(String var1);

        public Builder modality(TestSetModality var1);

        public Builder testSetTags(Map<String, String> var1);
    }
}

