/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DialogActionType {
    ELICIT_INTENT("ElicitIntent"),
    START_INTENT("StartIntent"),
    ELICIT_SLOT("ElicitSlot"),
    EVALUATE_CONDITIONAL("EvaluateConditional"),
    INVOKE_DIALOG_CODE_HOOK("InvokeDialogCodeHook"),
    CONFIRM_INTENT("ConfirmIntent"),
    FULFILL_INTENT("FulfillIntent"),
    CLOSE_INTENT("CloseIntent"),
    END_CONVERSATION("EndConversation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DialogActionType> VALUE_MAP;
    private final String value;

    private DialogActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DialogActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DialogActionType> knownValues() {
        EnumSet<DialogActionType> knownValues = EnumSet.allOf(DialogActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DialogActionType.class, DialogActionType::toString);
    }
}

