/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup;
import software.amazon.awssdk.services.lexmodelsv2.model.MessageGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StillWaitingResponseSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StillWaitingResponseSpecification> {
    private static final SdkField<List<MessageGroup>> MESSAGE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messageGroups").getter(StillWaitingResponseSpecification.getter(StillWaitingResponseSpecification::messageGroups)).setter(StillWaitingResponseSpecification.setter(Builder::messageGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> FREQUENCY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("frequencyInSeconds").getter(StillWaitingResponseSpecification.getter(StillWaitingResponseSpecification::frequencyInSeconds)).setter(StillWaitingResponseSpecification.setter(Builder::frequencyInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequencyInSeconds").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInSeconds").getter(StillWaitingResponseSpecification.getter(StillWaitingResponseSpecification::timeoutInSeconds)).setter(StillWaitingResponseSpecification.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()}).build();
    private static final SdkField<Boolean> ALLOW_INTERRUPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowInterrupt").getter(StillWaitingResponseSpecification.getter(StillWaitingResponseSpecification::allowInterrupt)).setter(StillWaitingResponseSpecification.setter(Builder::allowInterrupt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowInterrupt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_GROUPS_FIELD, FREQUENCY_IN_SECONDS_FIELD, TIMEOUT_IN_SECONDS_FIELD, ALLOW_INTERRUPT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<MessageGroup> messageGroups;
    private final Integer frequencyInSeconds;
    private final Integer timeoutInSeconds;
    private final Boolean allowInterrupt;

    private StillWaitingResponseSpecification(BuilderImpl builder) {
        this.messageGroups = builder.messageGroups;
        this.frequencyInSeconds = builder.frequencyInSeconds;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.allowInterrupt = builder.allowInterrupt;
    }

    public final boolean hasMessageGroups() {
        return this.messageGroups != null && !(this.messageGroups instanceof SdkAutoConstructList);
    }

    public final List<MessageGroup> messageGroups() {
        return this.messageGroups;
    }

    public final Integer frequencyInSeconds() {
        return this.frequencyInSeconds;
    }

    public final Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public final Boolean allowInterrupt() {
        return this.allowInterrupt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageGroups() ? this.messageGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowInterrupt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StillWaitingResponseSpecification)) {
            return false;
        }
        StillWaitingResponseSpecification other = (StillWaitingResponseSpecification)obj;
        return this.hasMessageGroups() == other.hasMessageGroups() && Objects.equals(this.messageGroups(), other.messageGroups()) && Objects.equals(this.frequencyInSeconds(), other.frequencyInSeconds()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(this.allowInterrupt(), other.allowInterrupt());
    }

    public final String toString() {
        return ToString.builder((String)"StillWaitingResponseSpecification").add("MessageGroups", this.hasMessageGroups() ? this.messageGroups() : null).add("FrequencyInSeconds", (Object)this.frequencyInSeconds()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("AllowInterrupt", (Object)this.allowInterrupt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageGroups": {
                return Optional.ofNullable(clazz.cast(this.messageGroups()));
            }
            case "frequencyInSeconds": {
                return Optional.ofNullable(clazz.cast(this.frequencyInSeconds()));
            }
            case "timeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
            case "allowInterrupt": {
                return Optional.ofNullable(clazz.cast(this.allowInterrupt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StillWaitingResponseSpecification, T> g) {
        return obj -> g.apply((StillWaitingResponseSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MessageGroup> messageGroups = DefaultSdkAutoConstructList.getInstance();
        private Integer frequencyInSeconds;
        private Integer timeoutInSeconds;
        private Boolean allowInterrupt;

        private BuilderImpl() {
        }

        private BuilderImpl(StillWaitingResponseSpecification model) {
            this.messageGroups(model.messageGroups);
            this.frequencyInSeconds(model.frequencyInSeconds);
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.allowInterrupt(model.allowInterrupt);
        }

        public final List<MessageGroup.Builder> getMessageGroups() {
            List<MessageGroup.Builder> result = MessageGroupsListCopier.copyToBuilder(this.messageGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder messageGroups(Collection<MessageGroup> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copy(messageGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(MessageGroup ... messageGroups) {
            this.messageGroups(Arrays.asList(messageGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(Consumer<MessageGroup.Builder> ... messageGroups) {
            this.messageGroups(Stream.of(messageGroups).map(c -> (MessageGroup)((MessageGroup.Builder)MessageGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessageGroups(Collection<MessageGroup.BuilderImpl> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copyFromBuilder(messageGroups);
        }

        public final Integer getFrequencyInSeconds() {
            return this.frequencyInSeconds;
        }

        @Override
        public final Builder frequencyInSeconds(Integer frequencyInSeconds) {
            this.frequencyInSeconds = frequencyInSeconds;
            return this;
        }

        public final void setFrequencyInSeconds(Integer frequencyInSeconds) {
            this.frequencyInSeconds = frequencyInSeconds;
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Boolean getAllowInterrupt() {
            return this.allowInterrupt;
        }

        @Override
        public final Builder allowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
            return this;
        }

        public final void setAllowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
        }

        public StillWaitingResponseSpecification build() {
            return new StillWaitingResponseSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StillWaitingResponseSpecification> {
        public Builder messageGroups(Collection<MessageGroup> var1);

        public Builder messageGroups(MessageGroup ... var1);

        public Builder messageGroups(Consumer<MessageGroup.Builder> ... var1);

        public Builder frequencyInSeconds(Integer var1);

        public Builder timeoutInSeconds(Integer var1);

        public Builder allowInterrupt(Boolean var1);
    }
}

