/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.BotSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBotsResponse> {
    private static final SdkField<List<BotSummary>> BOT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botSummaries").getter(ListBotsResponse.getter(ListBotsResponse::botSummaries)).setter(ListBotsResponse.setter(Builder::botSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotsResponse.getter(ListBotsResponse::nextToken)).setter(ListBotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<BotSummary> botSummaries;
    private final String nextToken;

    private ListBotsResponse(BuilderImpl builder) {
        super(builder);
        this.botSummaries = builder.botSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBotSummaries() {
        return this.botSummaries != null && !(this.botSummaries instanceof SdkAutoConstructList);
    }

    public final List<BotSummary> botSummaries() {
        return this.botSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotSummaries() ? this.botSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotsResponse)) {
            return false;
        }
        ListBotsResponse other = (ListBotsResponse)((Object)obj);
        return this.hasBotSummaries() == other.hasBotSummaries() && Objects.equals(this.botSummaries(), other.botSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotsResponse").add("BotSummaries", this.hasBotSummaries() ? this.botSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botSummaries": {
                return Optional.ofNullable(clazz.cast(this.botSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotsResponse, T> g) {
        return obj -> g.apply((ListBotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private List<BotSummary> botSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotsResponse model) {
            super(model);
            this.botSummaries(model.botSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<BotSummary.Builder> getBotSummaries() {
            List<BotSummary.Builder> result = BotSummaryListCopier.copyToBuilder(this.botSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder botSummaries(Collection<BotSummary> botSummaries) {
            this.botSummaries = BotSummaryListCopier.copy(botSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botSummaries(BotSummary ... botSummaries) {
            this.botSummaries(Arrays.asList(botSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botSummaries(Consumer<BotSummary.Builder> ... botSummaries) {
            this.botSummaries(Stream.of(botSummaries).map(c -> (BotSummary)((BotSummary.Builder)BotSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBotSummaries(Collection<BotSummary.BuilderImpl> botSummaries) {
            this.botSummaries = BotSummaryListCopier.copyFromBuilder(botSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBotsResponse build() {
            return new ListBotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotsResponse> {
        public Builder botSummaries(Collection<BotSummary> var1);

        public Builder botSummaries(BotSummary ... var1);

        public Builder botSummaries(Consumer<BotSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

