/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.ConditionMapCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.Effect;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.OperationListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.Principal;
import software.amazon.awssdk.services.lexmodelsv2.model.PrincipalListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourcePolicyStatementRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, CreateResourcePolicyStatementRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(CreateResourcePolicyStatementRequest.getter(CreateResourcePolicyStatementRequest::resourceArn)).setter(CreateResourcePolicyStatementRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceArn").build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statementId").getter(CreateResourcePolicyStatementRequest.getter(CreateResourcePolicyStatementRequest::statementId)).setter(CreateResourcePolicyStatementRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("effect").getter(CreateResourcePolicyStatementRequest.getter(CreateResourcePolicyStatementRequest::effectAsString)).setter(CreateResourcePolicyStatementRequest.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effect").build()}).build();
    private static final SdkField<List<Principal>> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("principal").getter(CreateResourcePolicyStatementRequest.getter(CreateResourcePolicyStatementRequest::principal)).setter(CreateResourcePolicyStatementRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("action").getter(CreateResourcePolicyStatementRequest.getter(CreateResourcePolicyStatementRequest::action)).setter(CreateResourcePolicyStatementRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("condition").getter(CreateResourcePolicyStatementRequest.getter(CreateResourcePolicyStatementRequest::condition)).setter(CreateResourcePolicyStatementRequest.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> EXPECTED_REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedRevisionId").getter(CreateResourcePolicyStatementRequest.getter(CreateResourcePolicyStatementRequest::expectedRevisionId)).setter(CreateResourcePolicyStatementRequest.setter(Builder::expectedRevisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("expectedRevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, STATEMENT_ID_FIELD, EFFECT_FIELD, PRINCIPAL_FIELD, ACTION_FIELD, CONDITION_FIELD, EXPECTED_REVISION_ID_FIELD));
    private final String resourceArn;
    private final String statementId;
    private final String effect;
    private final List<Principal> principal;
    private final List<String> action;
    private final Map<String, Map<String, String>> condition;
    private final String expectedRevisionId;

    private CreateResourcePolicyStatementRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.statementId = builder.statementId;
        this.effect = builder.effect;
        this.principal = builder.principal;
        this.action = builder.action;
        this.condition = builder.condition;
        this.expectedRevisionId = builder.expectedRevisionId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String statementId() {
        return this.statementId;
    }

    public final Effect effect() {
        return Effect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final boolean hasPrincipal() {
        return this.principal != null && !(this.principal instanceof SdkAutoConstructList);
    }

    public final List<Principal> principal() {
        return this.principal;
    }

    public final boolean hasAction() {
        return this.action != null && !(this.action instanceof SdkAutoConstructList);
    }

    public final List<String> action() {
        return this.action;
    }

    public final boolean hasCondition() {
        return this.condition != null && !(this.condition instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> condition() {
        return this.condition;
    }

    public final String expectedRevisionId() {
        return this.expectedRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipal() ? this.principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAction() ? this.action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCondition() ? this.condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedRevisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourcePolicyStatementRequest)) {
            return false;
        }
        CreateResourcePolicyStatementRequest other = (CreateResourcePolicyStatementRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.statementId(), other.statementId()) && Objects.equals(this.effectAsString(), other.effectAsString()) && this.hasPrincipal() == other.hasPrincipal() && Objects.equals(this.principal(), other.principal()) && this.hasAction() == other.hasAction() && Objects.equals(this.action(), other.action()) && this.hasCondition() == other.hasCondition() && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.expectedRevisionId(), other.expectedRevisionId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourcePolicyStatementRequest").add("ResourceArn", (Object)this.resourceArn()).add("StatementId", (Object)this.statementId()).add("Effect", (Object)this.effectAsString()).add("Principal", this.hasPrincipal() ? this.principal() : null).add("Action", this.hasAction() ? this.action() : null).add("Condition", this.hasCondition() ? this.condition() : null).add("ExpectedRevisionId", (Object)this.expectedRevisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "statementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
            case "effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "expectedRevisionId": {
                return Optional.ofNullable(clazz.cast(this.expectedRevisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourcePolicyStatementRequest, T> g) {
        return obj -> g.apply((CreateResourcePolicyStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String statementId;
        private String effect;
        private List<Principal> principal = DefaultSdkAutoConstructList.getInstance();
        private List<String> action = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Map<String, String>> condition = DefaultSdkAutoConstructMap.getInstance();
        private String expectedRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourcePolicyStatementRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.statementId(model.statementId);
            this.effect(model.effect);
            this.principal(model.principal);
            this.action(model.action);
            this.condition(model.condition);
            this.expectedRevisionId(model.expectedRevisionId);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public final String getEffect() {
            return this.effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(Effect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        public final List<Principal.Builder> getPrincipal() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.principal);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder principal(Collection<Principal> principal) {
            this.principal = PrincipalListCopier.copy(principal);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principal(Principal ... principal) {
            this.principal(Arrays.asList(principal));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principal(Consumer<Principal.Builder> ... principal) {
            this.principal(Stream.of(principal).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipal(Collection<Principal.BuilderImpl> principal) {
            this.principal = PrincipalListCopier.copyFromBuilder(principal);
        }

        public final Collection<String> getAction() {
            if (this.action instanceof SdkAutoConstructList) {
                return null;
            }
            return this.action;
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = OperationListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String ... action) {
            this.action(Arrays.asList(action));
            return this;
        }

        public final void setAction(Collection<String> action) {
            this.action = OperationListCopier.copy(action);
        }

        public final Map<String, ? extends Map<String, String>> getCondition() {
            if (this.condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.condition;
        }

        @Override
        public final Builder condition(Map<String, ? extends Map<String, String>> condition) {
            this.condition = ConditionMapCopier.copy(condition);
            return this;
        }

        public final void setCondition(Map<String, ? extends Map<String, String>> condition) {
            this.condition = ConditionMapCopier.copy(condition);
        }

        public final String getExpectedRevisionId() {
            return this.expectedRevisionId;
        }

        @Override
        public final Builder expectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
            return this;
        }

        public final void setExpectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourcePolicyStatementRequest build() {
            return new CreateResourcePolicyStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourcePolicyStatementRequest> {
        public Builder resourceArn(String var1);

        public Builder statementId(String var1);

        public Builder effect(String var1);

        public Builder effect(Effect var1);

        public Builder principal(Collection<Principal> var1);

        public Builder principal(Principal ... var1);

        public Builder principal(Consumer<Principal.Builder> ... var1);

        public Builder action(Collection<String> var1);

        public Builder action(String ... var1);

        public Builder condition(Map<String, ? extends Map<String, String>> var1);

        public Builder expectedRevisionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

