/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.VoiceSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBotLocaleResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, UpdateBotLocaleResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::botId)).setter(UpdateBotLocaleResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::botVersion)).setter(UpdateBotLocaleResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::localeId)).setter(UpdateBotLocaleResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> LOCALE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeName").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::localeName)).setter(UpdateBotLocaleResponse.setter(Builder::localeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::description)).setter(UpdateBotLocaleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("nluIntentConfidenceThreshold").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::nluIntentConfidenceThreshold)).setter(UpdateBotLocaleResponse.setter(Builder::nluIntentConfidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold").build()}).build();
    private static final SdkField<VoiceSettings> VOICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("voiceSettings").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::voiceSettings)).setter(UpdateBotLocaleResponse.setter(Builder::voiceSettings)).constructor(VoiceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceSettings").build()}).build();
    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botLocaleStatus").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::botLocaleStatusAsString)).setter(UpdateBotLocaleResponse.setter(Builder::botLocaleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::failureReasons)).setter(UpdateBotLocaleResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::creationDateTime)).setter(UpdateBotLocaleResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(UpdateBotLocaleResponse.getter(UpdateBotLocaleResponse::lastUpdatedDateTime)).setter(UpdateBotLocaleResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, LOCALE_NAME_FIELD, DESCRIPTION_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD, VOICE_SETTINGS_FIELD, BOT_LOCALE_STATUS_FIELD, FAILURE_REASONS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String localeName;
    private final String description;
    private final Double nluIntentConfidenceThreshold;
    private final VoiceSettings voiceSettings;
    private final String botLocaleStatus;
    private final List<String> failureReasons;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private UpdateBotLocaleResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.localeName = builder.localeName;
        this.description = builder.description;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.voiceSettings = builder.voiceSettings;
        this.botLocaleStatus = builder.botLocaleStatus;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String localeName() {
        return this.localeName;
    }

    public final String description() {
        return this.description;
    }

    public final Double nluIntentConfidenceThreshold() {
        return this.nluIntentConfidenceThreshold;
    }

    public final VoiceSettings voiceSettings() {
        return this.voiceSettings;
    }

    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(this.botLocaleStatus);
    }

    public final String botLocaleStatusAsString() {
        return this.botLocaleStatus;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.botLocaleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBotLocaleResponse)) {
            return false;
        }
        UpdateBotLocaleResponse other = (UpdateBotLocaleResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.localeName(), other.localeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold()) && Objects.equals(this.voiceSettings(), other.voiceSettings()) && Objects.equals(this.botLocaleStatusAsString(), other.botLocaleStatusAsString()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBotLocaleResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("LocaleName", (Object)this.localeName()).add("Description", (Object)this.description()).add("NluIntentConfidenceThreshold", (Object)this.nluIntentConfidenceThreshold()).add("VoiceSettings", (Object)this.voiceSettings()).add("BotLocaleStatus", (Object)this.botLocaleStatusAsString()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "localeName": {
                return Optional.ofNullable(clazz.cast(this.localeName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "nluIntentConfidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.nluIntentConfidenceThreshold()));
            }
            case "voiceSettings": {
                return Optional.ofNullable(clazz.cast(this.voiceSettings()));
            }
            case "botLocaleStatus": {
                return Optional.ofNullable(clazz.cast(this.botLocaleStatusAsString()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBotLocaleResponse, T> g) {
        return obj -> g.apply((UpdateBotLocaleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String localeName;
        private String description;
        private Double nluIntentConfidenceThreshold;
        private VoiceSettings voiceSettings;
        private String botLocaleStatus;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBotLocaleResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.localeName(model.localeName);
            this.description(model.description);
            this.nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            this.voiceSettings(model.voiceSettings);
            this.botLocaleStatus(model.botLocaleStatus);
            this.failureReasons(model.failureReasons);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getBotId() {
            return this.botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final String getLocaleName() {
            return this.localeName;
        }

        @Override
        public final Builder localeName(String localeName) {
            this.localeName = localeName;
            return this;
        }

        public final void setLocaleName(String localeName) {
            this.localeName = localeName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return this.nluIntentConfidenceThreshold;
        }

        @Override
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        public final VoiceSettings.Builder getVoiceSettings() {
            return this.voiceSettings != null ? this.voiceSettings.toBuilder() : null;
        }

        @Override
        public final Builder voiceSettings(VoiceSettings voiceSettings) {
            this.voiceSettings = voiceSettings;
            return this;
        }

        public final void setVoiceSettings(VoiceSettings.BuilderImpl voiceSettings) {
            this.voiceSettings = voiceSettings != null ? voiceSettings.build() : null;
        }

        public final String getBotLocaleStatus() {
            return this.botLocaleStatus;
        }

        @Override
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public UpdateBotLocaleResponse build() {
            return new UpdateBotLocaleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBotLocaleResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder localeName(String var1);

        public Builder description(String var1);

        public Builder nluIntentConfidenceThreshold(Double var1);

        public Builder voiceSettings(VoiceSettings var1);

        default public Builder voiceSettings(Consumer<VoiceSettings.Builder> voiceSettings) {
            return this.voiceSettings((VoiceSettings)((VoiceSettings.Builder)VoiceSettings.builder().applyMutation(voiceSettings)).build());
        }

        public Builder botLocaleStatus(String var1);

        public Builder botLocaleStatus(BotLocaleStatus var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

