/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBotAliasResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeBotAliasResponse.Builder, DescribeBotAliasResponse> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(DescribeBotAliasResponse::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasName").getter(getter(DescribeBotAliasResponse::botAliasName))
            .setter(setter(Builder::botAliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeBotAliasResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DescribeBotAliasResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<Map<String, BotAliasLocaleSettings>> BOT_ALIAS_LOCALE_SETTINGS_FIELD = SdkField
            .<Map<String, BotAliasLocaleSettings>> builder(MarshallingType.MAP)
            .memberName("botAliasLocaleSettings")
            .getter(getter(DescribeBotAliasResponse::botAliasLocaleSettings))
            .setter(setter(Builder::botAliasLocaleSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasLocaleSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BotAliasLocaleSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotAliasLocaleSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConversationLogSettings> CONVERSATION_LOG_SETTINGS_FIELD = SdkField
            .<ConversationLogSettings> builder(MarshallingType.SDK_POJO).memberName("conversationLogSettings")
            .getter(getter(DescribeBotAliasResponse::conversationLogSettings)).setter(setter(Builder::conversationLogSettings))
            .constructor(ConversationLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogSettings").build())
            .build();

    private static final SdkField<SentimentAnalysisSettings> SENTIMENT_ANALYSIS_SETTINGS_FIELD = SdkField
            .<SentimentAnalysisSettings> builder(MarshallingType.SDK_POJO).memberName("sentimentAnalysisSettings")
            .getter(getter(DescribeBotAliasResponse::sentimentAnalysisSettings))
            .setter(setter(Builder::sentimentAnalysisSettings)).constructor(SentimentAnalysisSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentAnalysisSettings").build())
            .build();

    private static final SdkField<List<BotAliasHistoryEvent>> BOT_ALIAS_HISTORY_EVENTS_FIELD = SdkField
            .<List<BotAliasHistoryEvent>> builder(MarshallingType.LIST)
            .memberName("botAliasHistoryEvents")
            .getter(getter(DescribeBotAliasResponse::botAliasHistoryEvents))
            .setter(setter(Builder::botAliasHistoryEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasHistoryEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotAliasHistoryEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotAliasHistoryEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BOT_ALIAS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasStatus").getter(getter(DescribeBotAliasResponse::botAliasStatusAsString))
            .setter(setter(Builder::botAliasStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasStatus").build()).build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeBotAliasResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeBotAliasResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeBotAliasResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD,
            BOT_ALIAS_NAME_FIELD, DESCRIPTION_FIELD, BOT_VERSION_FIELD, BOT_ALIAS_LOCALE_SETTINGS_FIELD,
            CONVERSATION_LOG_SETTINGS_FIELD, SENTIMENT_ANALYSIS_SETTINGS_FIELD, BOT_ALIAS_HISTORY_EVENTS_FIELD,
            BOT_ALIAS_STATUS_FIELD, BOT_ID_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private final String botAliasId;

    private final String botAliasName;

    private final String description;

    private final String botVersion;

    private final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings;

    private final ConversationLogSettings conversationLogSettings;

    private final SentimentAnalysisSettings sentimentAnalysisSettings;

    private final List<BotAliasHistoryEvent> botAliasHistoryEvents;

    private final String botAliasStatus;

    private final String botId;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private DescribeBotAliasResponse(BuilderImpl builder) {
        super(builder);
        this.botAliasId = builder.botAliasId;
        this.botAliasName = builder.botAliasName;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botAliasLocaleSettings = builder.botAliasLocaleSettings;
        this.conversationLogSettings = builder.conversationLogSettings;
        this.sentimentAnalysisSettings = builder.sentimentAnalysisSettings;
        this.botAliasHistoryEvents = builder.botAliasHistoryEvents;
        this.botAliasStatus = builder.botAliasStatus;
        this.botId = builder.botId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The identifier of the bot alias.
     * </p>
     * 
     * @return The identifier of the bot alias.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The name of the bot alias.
     * </p>
     * 
     * @return The name of the bot alias.
     */
    public final String botAliasName() {
        return botAliasName;
    }

    /**
     * <p>
     * The description of the bot alias.
     * </p>
     * 
     * @return The description of the bot alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version of the bot associated with the bot alias.
     * </p>
     * 
     * @return The version of the bot associated with the bot alias.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * Returns true if the BotAliasLocaleSettings property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBotAliasLocaleSettings() {
        return botAliasLocaleSettings != null && !(botAliasLocaleSettings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The locale settings that are unique to the alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBotAliasLocaleSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The locale settings that are unique to the alias.
     */
    public final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings() {
        return botAliasLocaleSettings;
    }

    /**
     * <p>
     * Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.
     * </p>
     * 
     * @return Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.
     */
    public final ConversationLogSettings conversationLogSettings() {
        return conversationLogSettings;
    }

    /**
     * Returns the value of the SentimentAnalysisSettings property for this object.
     * 
     * @return The value of the SentimentAnalysisSettings property for this object.
     */
    public final SentimentAnalysisSettings sentimentAnalysisSettings() {
        return sentimentAnalysisSettings;
    }

    /**
     * Returns true if the BotAliasHistoryEvents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBotAliasHistoryEvents() {
        return botAliasHistoryEvents != null && !(botAliasHistoryEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of events that affect a bot alias. For example, an event is recorded when the version that the alias
     * points to changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBotAliasHistoryEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of events that affect a bot alias. For example, an event is recorded when the version that the
     *         alias points to changes.
     */
    public final List<BotAliasHistoryEvent> botAliasHistoryEvents() {
        return botAliasHistoryEvents;
    }

    /**
     * <p>
     * The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your
     * bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botAliasStatus}
     * will return {@link BotAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botAliasStatusAsString}.
     * </p>
     * 
     * @return The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use
     *         with your bot.
     * @see BotAliasStatus
     */
    public final BotAliasStatus botAliasStatus() {
        return BotAliasStatus.fromValue(botAliasStatus);
    }

    /**
     * <p>
     * The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your
     * bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botAliasStatus}
     * will return {@link BotAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botAliasStatusAsString}.
     * </p>
     * 
     * @return The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use
     *         with your bot.
     * @see BotAliasStatus
     */
    public final String botAliasStatusAsString() {
        return botAliasStatus;
    }

    /**
     * <p>
     * The identifier of the bot associated with the bot alias.
     * </p>
     * 
     * @return The identifier of the bot associated with the bot alias.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * A timestamp of the date and time that the alias was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the alias was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * A timestamp of the date and time that the alias was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the alias was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotAliasLocaleSettings() ? botAliasLocaleSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conversationLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAnalysisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotAliasHistoryEvents() ? botAliasHistoryEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(botAliasStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotAliasResponse)) {
            return false;
        }
        DescribeBotAliasResponse other = (DescribeBotAliasResponse) obj;
        return Objects.equals(botAliasId(), other.botAliasId()) && Objects.equals(botAliasName(), other.botAliasName())
                && Objects.equals(description(), other.description()) && Objects.equals(botVersion(), other.botVersion())
                && hasBotAliasLocaleSettings() == other.hasBotAliasLocaleSettings()
                && Objects.equals(botAliasLocaleSettings(), other.botAliasLocaleSettings())
                && Objects.equals(conversationLogSettings(), other.conversationLogSettings())
                && Objects.equals(sentimentAnalysisSettings(), other.sentimentAnalysisSettings())
                && hasBotAliasHistoryEvents() == other.hasBotAliasHistoryEvents()
                && Objects.equals(botAliasHistoryEvents(), other.botAliasHistoryEvents())
                && Objects.equals(botAliasStatusAsString(), other.botAliasStatusAsString())
                && Objects.equals(botId(), other.botId()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBotAliasResponse").add("BotAliasId", botAliasId()).add("BotAliasName", botAliasName())
                .add("Description", description()).add("BotVersion", botVersion())
                .add("BotAliasLocaleSettings", hasBotAliasLocaleSettings() ? botAliasLocaleSettings() : null)
                .add("ConversationLogSettings", conversationLogSettings())
                .add("SentimentAnalysisSettings", sentimentAnalysisSettings())
                .add("BotAliasHistoryEvents", hasBotAliasHistoryEvents() ? botAliasHistoryEvents() : null)
                .add("BotAliasStatus", botAliasStatusAsString()).add("BotId", botId())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botAliasName":
            return Optional.ofNullable(clazz.cast(botAliasName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botAliasLocaleSettings":
            return Optional.ofNullable(clazz.cast(botAliasLocaleSettings()));
        case "conversationLogSettings":
            return Optional.ofNullable(clazz.cast(conversationLogSettings()));
        case "sentimentAnalysisSettings":
            return Optional.ofNullable(clazz.cast(sentimentAnalysisSettings()));
        case "botAliasHistoryEvents":
            return Optional.ofNullable(clazz.cast(botAliasHistoryEvents()));
        case "botAliasStatus":
            return Optional.ofNullable(clazz.cast(botAliasStatusAsString()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotAliasResponse, T> g) {
        return obj -> g.apply((DescribeBotAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBotAliasResponse> {
        /**
         * <p>
         * The identifier of the bot alias.
         * </p>
         * 
         * @param botAliasId
         *        The identifier of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The name of the bot alias.
         * </p>
         * 
         * @param botAliasName
         *        The name of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasName(String botAliasName);

        /**
         * <p>
         * The description of the bot alias.
         * </p>
         * 
         * @param description
         *        The description of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the bot associated with the bot alias.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The locale settings that are unique to the alias.
         * </p>
         * 
         * @param botAliasLocaleSettings
         *        The locale settings that are unique to the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> botAliasLocaleSettings);

        /**
         * <p>
         * Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.
         * </p>
         * 
         * @param conversationLogSettings
         *        Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLogSettings(ConversationLogSettings conversationLogSettings);

        /**
         * <p>
         * Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.
         * </p>
         * This is a convenience that creates an instance of the {@link ConversationLogSettings.Builder} avoiding the
         * need to create one manually via {@link ConversationLogSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConversationLogSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #conversationLogSettings(ConversationLogSettings)}.
         * 
         * @param conversationLogSettings
         *        a consumer that will call methods on {@link ConversationLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLogSettings(ConversationLogSettings)
         */
        default Builder conversationLogSettings(Consumer<ConversationLogSettings.Builder> conversationLogSettings) {
            return conversationLogSettings(ConversationLogSettings.builder().applyMutation(conversationLogSettings).build());
        }

        /**
         * Sets the value of the SentimentAnalysisSettings property for this object.
         *
         * @param sentimentAnalysisSettings
         *        The new value for the SentimentAnalysisSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentAnalysisSettings(SentimentAnalysisSettings sentimentAnalysisSettings);

        /**
         * Sets the value of the SentimentAnalysisSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link SentimentAnalysisSettings.Builder} avoiding the
         * need to create one manually via {@link SentimentAnalysisSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link SentimentAnalysisSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #sentimentAnalysisSettings(SentimentAnalysisSettings)}.
         * 
         * @param sentimentAnalysisSettings
         *        a consumer that will call methods on {@link SentimentAnalysisSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentAnalysisSettings(SentimentAnalysisSettings)
         */
        default Builder sentimentAnalysisSettings(Consumer<SentimentAnalysisSettings.Builder> sentimentAnalysisSettings) {
            return sentimentAnalysisSettings(SentimentAnalysisSettings.builder().applyMutation(sentimentAnalysisSettings).build());
        }

        /**
         * <p>
         * A list of events that affect a bot alias. For example, an event is recorded when the version that the alias
         * points to changes.
         * </p>
         * 
         * @param botAliasHistoryEvents
         *        A list of events that affect a bot alias. For example, an event is recorded when the version that the
         *        alias points to changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasHistoryEvents(Collection<BotAliasHistoryEvent> botAliasHistoryEvents);

        /**
         * <p>
         * A list of events that affect a bot alias. For example, an event is recorded when the version that the alias
         * points to changes.
         * </p>
         * 
         * @param botAliasHistoryEvents
         *        A list of events that affect a bot alias. For example, an event is recorded when the version that the
         *        alias points to changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasHistoryEvents(BotAliasHistoryEvent... botAliasHistoryEvents);

        /**
         * <p>
         * A list of events that affect a bot alias. For example, an event is recorded when the version that the alias
         * points to changes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BotAliasHistoryEvent>.Builder} avoiding the
         * need to create one manually via {@link List<BotAliasHistoryEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotAliasHistoryEvent>.Builder#build()} is called immediately
         * and its result is passed to {@link #botAliasHistoryEvents(List<BotAliasHistoryEvent>)}.
         * 
         * @param botAliasHistoryEvents
         *        a consumer that will call methods on {@link List<BotAliasHistoryEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botAliasHistoryEvents(List<BotAliasHistoryEvent>)
         */
        Builder botAliasHistoryEvents(Consumer<BotAliasHistoryEvent.Builder>... botAliasHistoryEvents);

        /**
         * <p>
         * The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with
         * your bot.
         * </p>
         * 
         * @param botAliasStatus
         *        The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use
         *        with your bot.
         * @see BotAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasStatus
         */
        Builder botAliasStatus(String botAliasStatus);

        /**
         * <p>
         * The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with
         * your bot.
         * </p>
         * 
         * @param botAliasStatus
         *        The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use
         *        with your bot.
         * @see BotAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasStatus
         */
        Builder botAliasStatus(BotAliasStatus botAliasStatus);

        /**
         * <p>
         * The identifier of the bot associated with the bot alias.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * A timestamp of the date and time that the alias was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A timestamp of the date and time that the alias was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the alias was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botAliasId;

        private String botAliasName;

        private String description;

        private String botVersion;

        private Map<String, BotAliasLocaleSettings> botAliasLocaleSettings = DefaultSdkAutoConstructMap.getInstance();

        private ConversationLogSettings conversationLogSettings;

        private SentimentAnalysisSettings sentimentAnalysisSettings;

        private List<BotAliasHistoryEvent> botAliasHistoryEvents = DefaultSdkAutoConstructList.getInstance();

        private String botAliasStatus;

        private String botId;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotAliasResponse model) {
            super(model);
            botAliasId(model.botAliasId);
            botAliasName(model.botAliasName);
            description(model.description);
            botVersion(model.botVersion);
            botAliasLocaleSettings(model.botAliasLocaleSettings);
            conversationLogSettings(model.conversationLogSettings);
            sentimentAnalysisSettings(model.sentimentAnalysisSettings);
            botAliasHistoryEvents(model.botAliasHistoryEvents);
            botAliasStatus(model.botAliasStatus);
            botId(model.botId);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        public final String getBotAliasName() {
            return botAliasName;
        }

        @Override
        public final Builder botAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
            return this;
        }

        public final void setBotAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final Map<String, BotAliasLocaleSettings.Builder> getBotAliasLocaleSettings() {
            if (botAliasLocaleSettings instanceof SdkAutoConstructMap) {
                return null;
            }
            return botAliasLocaleSettings != null ? CollectionUtils.mapValues(botAliasLocaleSettings,
                    BotAliasLocaleSettings::toBuilder) : null;
        }

        @Override
        public final Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copy(botAliasLocaleSettings);
            return this;
        }

        public final void setBotAliasLocaleSettings(Map<String, BotAliasLocaleSettings.BuilderImpl> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copyFromBuilder(botAliasLocaleSettings);
        }

        public final ConversationLogSettings.Builder getConversationLogSettings() {
            return conversationLogSettings != null ? conversationLogSettings.toBuilder() : null;
        }

        @Override
        public final Builder conversationLogSettings(ConversationLogSettings conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings;
            return this;
        }

        public final void setConversationLogSettings(ConversationLogSettings.BuilderImpl conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings != null ? conversationLogSettings.build() : null;
        }

        public final SentimentAnalysisSettings.Builder getSentimentAnalysisSettings() {
            return sentimentAnalysisSettings != null ? sentimentAnalysisSettings.toBuilder() : null;
        }

        @Override
        public final Builder sentimentAnalysisSettings(SentimentAnalysisSettings sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings;
            return this;
        }

        public final void setSentimentAnalysisSettings(SentimentAnalysisSettings.BuilderImpl sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings != null ? sentimentAnalysisSettings.build() : null;
        }

        public final Collection<BotAliasHistoryEvent.Builder> getBotAliasHistoryEvents() {
            if (botAliasHistoryEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return botAliasHistoryEvents != null ? botAliasHistoryEvents.stream().map(BotAliasHistoryEvent::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder botAliasHistoryEvents(Collection<BotAliasHistoryEvent> botAliasHistoryEvents) {
            this.botAliasHistoryEvents = BotAliasHistoryEventsListCopier.copy(botAliasHistoryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliasHistoryEvents(BotAliasHistoryEvent... botAliasHistoryEvents) {
            botAliasHistoryEvents(Arrays.asList(botAliasHistoryEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliasHistoryEvents(Consumer<BotAliasHistoryEvent.Builder>... botAliasHistoryEvents) {
            botAliasHistoryEvents(Stream.of(botAliasHistoryEvents)
                    .map(c -> BotAliasHistoryEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBotAliasHistoryEvents(Collection<BotAliasHistoryEvent.BuilderImpl> botAliasHistoryEvents) {
            this.botAliasHistoryEvents = BotAliasHistoryEventsListCopier.copyFromBuilder(botAliasHistoryEvents);
        }

        public final String getBotAliasStatus() {
            return botAliasStatus;
        }

        @Override
        public final Builder botAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
            return this;
        }

        @Override
        public final Builder botAliasStatus(BotAliasStatus botAliasStatus) {
            this.botAliasStatus(botAliasStatus == null ? null : botAliasStatus.toString());
            return this;
        }

        public final void setBotAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public DescribeBotAliasResponse build() {
            return new DescribeBotAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
