/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MigrationStrategy {
    CREATE_NEW("CREATE_NEW"),
    UPDATE_EXISTING("UPDATE_EXISTING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MigrationStrategy> VALUE_MAP;
    private final String value;

    private MigrationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MigrationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MigrationStrategy> knownValues() {
        EnumSet<MigrationStrategy> knownValues = EnumSet.allOf(MigrationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MigrationStrategy.class, MigrationStrategy::toString);
    }
}

