/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentMetadataListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBuiltinIntentsResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetBuiltinIntentsResponse> {
    private static final SdkField<List<BuiltinIntentMetadata>> INTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("intents").getter(GetBuiltinIntentsResponse.getter(GetBuiltinIntentsResponse::intents)).setter(GetBuiltinIntentsResponse.setter(Builder::intents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuiltinIntentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetBuiltinIntentsResponse.getter(GetBuiltinIntentsResponse::nextToken)).setter(GetBuiltinIntentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BuiltinIntentMetadata> intents;
    private final String nextToken;

    private GetBuiltinIntentsResponse(BuilderImpl builder) {
        super(builder);
        this.intents = builder.intents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIntents() {
        return this.intents != null && !(this.intents instanceof SdkAutoConstructList);
    }

    public final List<BuiltinIntentMetadata> intents() {
        return this.intents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntents() ? this.intents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentsResponse)) {
            return false;
        }
        GetBuiltinIntentsResponse other = (GetBuiltinIntentsResponse)((Object)obj);
        return this.hasIntents() == other.hasIntents() && Objects.equals(this.intents(), other.intents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetBuiltinIntentsResponse").add("Intents", this.hasIntents() ? this.intents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intents": {
                return Optional.ofNullable(clazz.cast(this.intents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBuiltinIntentsResponse, T> g) {
        return obj -> g.apply((GetBuiltinIntentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<BuiltinIntentMetadata> intents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentsResponse model) {
            super(model);
            this.intents(model.intents);
            this.nextToken(model.nextToken);
        }

        public final Collection<BuiltinIntentMetadata.Builder> getIntents() {
            if (this.intents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.intents != null ? (Collection)this.intents.stream().map(BuiltinIntentMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<BuiltinIntentMetadata> intents) {
            this.intents = BuiltinIntentMetadataListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(BuiltinIntentMetadata ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Consumer<BuiltinIntentMetadata.Builder> ... intents) {
            this.intents(Stream.of(intents).map(c -> (BuiltinIntentMetadata)((BuiltinIntentMetadata.Builder)BuiltinIntentMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntents(Collection<BuiltinIntentMetadata.BuilderImpl> intents) {
            this.intents = BuiltinIntentMetadataListCopier.copyFromBuilder(intents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBuiltinIntentsResponse build() {
            return new GetBuiltinIntentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBuiltinIntentsResponse> {
        public Builder intents(Collection<BuiltinIntentMetadata> var1);

        public Builder intents(BuiltinIntentMetadata ... var1);

        public Builder intents(Consumer<BuiltinIntentMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

