/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadDataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadDataSummary> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(WorkloadDataSummary.getter(WorkloadDataSummary::displayName)).setter(WorkloadDataSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadName").getter(WorkloadDataSummary.getter(WorkloadDataSummary::workloadName)).setter(WorkloadDataSummary.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, WORKLOAD_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkloadDataSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String displayName;
    private final String workloadName;

    private WorkloadDataSummary(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.workloadName = builder.workloadName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadDataSummary)) {
            return false;
        }
        WorkloadDataSummary other = (WorkloadDataSummary)obj;
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.workloadName(), other.workloadName());
    }

    public final String toString() {
        return ToString.builder((String)"WorkloadDataSummary").add("DisplayName", (Object)this.displayName()).add("WorkloadName", (Object)this.workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "workloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("workloadName", WORKLOAD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadDataSummary, T> g) {
        return obj -> g.apply((WorkloadDataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String displayName;
        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadDataSummary model) {
            this.displayName(model.displayName);
            this.workloadName(model.workloadName);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public WorkloadDataSummary build() {
            return new WorkloadDataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadDataSummary> {
        public Builder displayName(String var1);

        public Builder workloadName(String var1);
    }
}

