/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.launchwizard.model.LaunchWizardResponse;
import software.amazon.awssdk.services.launchwizard.model.WorkloadDataSummary;
import software.amazon.awssdk.services.launchwizard.model.WorkloadDataSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkloadsResponse
extends LaunchWizardResponse
implements ToCopyableBuilder<Builder, ListWorkloadsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkloadsResponse.getter(ListWorkloadsResponse::nextToken)).setter(ListWorkloadsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<WorkloadDataSummary>> WORKLOADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workloads").getter(ListWorkloadsResponse.getter(ListWorkloadsResponse::workloads)).setter(ListWorkloadsResponse.setter(Builder::workloads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloads").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadDataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKLOADS_FIELD));
    private final String nextToken;
    private final List<WorkloadDataSummary> workloads;

    private ListWorkloadsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workloads = builder.workloads;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkloads() {
        return this.workloads != null && !(this.workloads instanceof SdkAutoConstructList);
    }

    public final List<WorkloadDataSummary> workloads() {
        return this.workloads;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloads() ? this.workloads() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadsResponse)) {
            return false;
        }
        ListWorkloadsResponse other = (ListWorkloadsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkloads() == other.hasWorkloads() && Objects.equals(this.workloads(), other.workloads());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkloadsResponse").add("NextToken", (Object)this.nextToken()).add("Workloads", this.hasWorkloads() ? this.workloads() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workloads": {
                return Optional.ofNullable(clazz.cast(this.workloads()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadsResponse, T> g) {
        return obj -> g.apply((ListWorkloadsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LaunchWizardResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkloadDataSummary> workloads = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workloads(model.workloads);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkloadDataSummary.Builder> getWorkloads() {
            List<WorkloadDataSummary.Builder> result = WorkloadDataSummaryListCopier.copyToBuilder(this.workloads);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloads(Collection<WorkloadDataSummary.BuilderImpl> workloads) {
            this.workloads = WorkloadDataSummaryListCopier.copyFromBuilder(workloads);
        }

        @Override
        public final Builder workloads(Collection<WorkloadDataSummary> workloads) {
            this.workloads = WorkloadDataSummaryListCopier.copy(workloads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloads(WorkloadDataSummary ... workloads) {
            this.workloads(Arrays.asList(workloads));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloads(Consumer<WorkloadDataSummary.Builder> ... workloads) {
            this.workloads(Stream.of(workloads).map(c -> (WorkloadDataSummary)((WorkloadDataSummary.Builder)WorkloadDataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkloadsResponse build() {
            return new ListWorkloadsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LaunchWizardResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkloadsResponse> {
        public Builder nextToken(String var1);

        public Builder workloads(Collection<WorkloadDataSummary> var1);

        public Builder workloads(WorkloadDataSummary ... var1);

        public Builder workloads(Consumer<WorkloadDataSummary.Builder> ... var1);
    }
}

