/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.EnvironmentResponse;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.Layer;
import software.amazon.awssdk.services.lambda.model.LayersReferenceListCopier;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.TracingConfigResponse;
import software.amazon.awssdk.services.lambda.model.VpcConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFunctionConfigurationResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, UpdateFunctionConfigurationResponse> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::functionName)).setter(UpdateFunctionConfigurationResponse.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::functionArn)).setter(UpdateFunctionConfigurationResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::runtimeAsString)).setter(UpdateFunctionConfigurationResponse.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::role)).setter(UpdateFunctionConfigurationResponse.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::handler)).setter(UpdateFunctionConfigurationResponse.setter(Builder::handler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()}).build();
    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::codeSize)).setter(UpdateFunctionConfigurationResponse.setter(Builder::codeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::description)).setter(UpdateFunctionConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::timeout)).setter(UpdateFunctionConfigurationResponse.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::memorySize)).setter(UpdateFunctionConfigurationResponse.setter(Builder::memorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::lastModified)).setter(UpdateFunctionConfigurationResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::codeSha256)).setter(UpdateFunctionConfigurationResponse.setter(Builder::codeSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSha256").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::version)).setter(UpdateFunctionConfigurationResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<VpcConfigResponse> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::vpcConfig)).setter(UpdateFunctionConfigurationResponse.setter(Builder::vpcConfig)).constructor(VpcConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::deadLetterConfig)).setter(UpdateFunctionConfigurationResponse.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<EnvironmentResponse> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::environment)).setter(UpdateFunctionConfigurationResponse.setter(Builder::environment)).constructor(EnvironmentResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::kmsKeyArn)).setter(UpdateFunctionConfigurationResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()}).build();
    private static final SdkField<TracingConfigResponse> TRACING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::tracingConfig)).setter(UpdateFunctionConfigurationResponse.setter(Builder::tracingConfig)).constructor(TracingConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()}).build();
    private static final SdkField<String> MASTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::masterArn)).setter(UpdateFunctionConfigurationResponse.setter(Builder::masterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterArn").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::revisionId)).setter(UpdateFunctionConfigurationResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateFunctionConfigurationResponse.getter(UpdateFunctionConfigurationResponse::layers)).setter(UpdateFunctionConfigurationResponse.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Layer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, FUNCTION_ARN_FIELD, RUNTIME_FIELD, ROLE_FIELD, HANDLER_FIELD, CODE_SIZE_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD, MEMORY_SIZE_FIELD, LAST_MODIFIED_FIELD, CODE_SHA256_FIELD, VERSION_FIELD, VPC_CONFIG_FIELD, DEAD_LETTER_CONFIG_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, TRACING_CONFIG_FIELD, MASTER_ARN_FIELD, REVISION_ID_FIELD, LAYERS_FIELD));
    private final String functionName;
    private final String functionArn;
    private final String runtime;
    private final String role;
    private final String handler;
    private final Long codeSize;
    private final String description;
    private final Integer timeout;
    private final Integer memorySize;
    private final String lastModified;
    private final String codeSha256;
    private final String version;
    private final VpcConfigResponse vpcConfig;
    private final DeadLetterConfig deadLetterConfig;
    private final EnvironmentResponse environment;
    private final String kmsKeyArn;
    private final TracingConfigResponse tracingConfig;
    private final String masterArn;
    private final String revisionId;
    private final List<Layer> layers;

    private UpdateFunctionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.functionArn = builder.functionArn;
        this.runtime = builder.runtime;
        this.role = builder.role;
        this.handler = builder.handler;
        this.codeSize = builder.codeSize;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.lastModified = builder.lastModified;
        this.codeSha256 = builder.codeSha256;
        this.version = builder.version;
        this.vpcConfig = builder.vpcConfig;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.masterArn = builder.masterArn;
        this.revisionId = builder.revisionId;
        this.layers = builder.layers;
    }

    public String functionName() {
        return this.functionName;
    }

    public String functionArn() {
        return this.functionArn;
    }

    public Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public String runtimeAsString() {
        return this.runtime;
    }

    public String role() {
        return this.role;
    }

    public String handler() {
        return this.handler;
    }

    public Long codeSize() {
        return this.codeSize;
    }

    public String description() {
        return this.description;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Integer memorySize() {
        return this.memorySize;
    }

    public String lastModified() {
        return this.lastModified;
    }

    public String codeSha256() {
        return this.codeSha256;
    }

    public String version() {
        return this.version;
    }

    public VpcConfigResponse vpcConfig() {
        return this.vpcConfig;
    }

    public DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public EnvironmentResponse environment() {
        return this.environment;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public TracingConfigResponse tracingConfig() {
        return this.tracingConfig;
    }

    public String masterArn() {
        return this.masterArn;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public List<Layer> layers() {
        return this.layers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionConfigurationResponse)) {
            return false;
        }
        UpdateFunctionConfigurationResponse other = (UpdateFunctionConfigurationResponse)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.handler(), other.handler()) && Objects.equals(this.codeSize(), other.codeSize()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.codeSha256(), other.codeSha256()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.tracingConfig(), other.tracingConfig()) && Objects.equals(this.masterArn(), other.masterArn()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.layers(), other.layers());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFunctionConfigurationResponse").add("FunctionName", (Object)this.functionName()).add("FunctionArn", (Object)this.functionArn()).add("Runtime", (Object)this.runtimeAsString()).add("Role", (Object)this.role()).add("Handler", (Object)this.handler()).add("CodeSize", (Object)this.codeSize()).add("Description", (Object)this.description()).add("Timeout", (Object)this.timeout()).add("MemorySize", (Object)this.memorySize()).add("LastModified", (Object)this.lastModified()).add("CodeSha256", (Object)this.codeSha256()).add("Version", (Object)this.version()).add("VpcConfig", (Object)this.vpcConfig()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("Environment", (Object)this.environment()).add("KMSKeyArn", (Object)this.kmsKeyArn()).add("TracingConfig", (Object)this.tracingConfig()).add("MasterArn", (Object)this.masterArn()).add("RevisionId", (Object)this.revisionId()).add("Layers", this.layers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "Runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Handler": {
                return Optional.ofNullable(clazz.cast(this.handler()));
            }
            case "CodeSize": {
                return Optional.ofNullable(clazz.cast(this.codeSize()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MemorySize": {
                return Optional.ofNullable(clazz.cast(this.memorySize()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "CodeSha256": {
                return Optional.ofNullable(clazz.cast(this.codeSha256()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "KMSKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "TracingConfig": {
                return Optional.ofNullable(clazz.cast(this.tracingConfig()));
            }
            case "MasterArn": {
                return Optional.ofNullable(clazz.cast(this.masterArn()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateFunctionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String functionName;
        private String functionArn;
        private String runtime;
        private String role;
        private String handler;
        private Long codeSize;
        private String description;
        private Integer timeout;
        private Integer memorySize;
        private String lastModified;
        private String codeSha256;
        private String version;
        private VpcConfigResponse vpcConfig;
        private DeadLetterConfig deadLetterConfig;
        private EnvironmentResponse environment;
        private String kmsKeyArn;
        private TracingConfigResponse tracingConfig;
        private String masterArn;
        private String revisionId;
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionConfigurationResponse model) {
            super(model);
            this.functionName(model.functionName);
            this.functionArn(model.functionArn);
            this.runtime(model.runtime);
            this.role(model.role);
            this.handler(model.handler);
            this.codeSize(model.codeSize);
            this.description(model.description);
            this.timeout(model.timeout);
            this.memorySize(model.memorySize);
            this.lastModified(model.lastModified);
            this.codeSha256(model.codeSha256);
            this.version(model.version);
            this.vpcConfig(model.vpcConfig);
            this.deadLetterConfig(model.deadLetterConfig);
            this.environment(model.environment);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tracingConfig(model.tracingConfig);
            this.masterArn(model.masterArn);
            this.revisionId(model.revisionId);
            this.layers(model.layers);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final String getRuntimeAsString() {
            return this.runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return this.handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final Long getCodeSize() {
            return this.codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final VpcConfigResponse.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigResponse vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfigResponse.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final EnvironmentResponse.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(EnvironmentResponse environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(EnvironmentResponse.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfigResponse.Builder getTracingConfig() {
            return this.tracingConfig != null ? this.tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfigResponse tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfigResponse.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public final String getMasterArn() {
            return this.masterArn;
        }

        @Override
        public final Builder masterArn(String masterArn) {
            this.masterArn = masterArn;
            return this;
        }

        public final void setMasterArn(String masterArn) {
            this.masterArn = masterArn;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final Collection<Layer.Builder> getLayers() {
            return this.layers != null ? (Collection)this.layers.stream().map(Layer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersReferenceListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder> ... layers) {
            this.layers(Stream.of(layers).map(c -> (Layer)((Layer.Builder)Layer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayersReferenceListCopier.copyFromBuilder(layers);
        }

        @Override
        public UpdateFunctionConfigurationResponse build() {
            return new UpdateFunctionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFunctionConfigurationResponse> {
        public Builder functionName(String var1);

        public Builder functionArn(String var1);

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder role(String var1);

        public Builder handler(String var1);

        public Builder codeSize(Long var1);

        public Builder description(String var1);

        public Builder timeout(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder lastModified(String var1);

        public Builder codeSha256(String var1);

        public Builder version(String var1);

        public Builder vpcConfig(VpcConfigResponse var1);

        default public Builder vpcConfig(Consumer<VpcConfigResponse.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfigResponse)((VpcConfigResponse.Builder)VpcConfigResponse.builder().applyMutation(vpcConfig)).build());
        }

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder environment(EnvironmentResponse var1);

        default public Builder environment(Consumer<EnvironmentResponse.Builder> environment) {
            return this.environment((EnvironmentResponse)((EnvironmentResponse.Builder)EnvironmentResponse.builder().applyMutation(environment)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tracingConfig(TracingConfigResponse var1);

        default public Builder tracingConfig(Consumer<TracingConfigResponse.Builder> tracingConfig) {
            return this.tracingConfig((TracingConfigResponse)((TracingConfigResponse.Builder)TracingConfigResponse.builder().applyMutation(tracingConfig)).build());
        }

        public Builder masterArn(String var1);

        public Builder revisionId(String var1);

        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);

        public Builder layers(Consumer<Layer.Builder> ... var1);
    }
}

