/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingsListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventSourceMappingsResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListEventSourceMappingsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListEventSourceMappingsResponse.getter(ListEventSourceMappingsResponse::nextMarker)).setter(ListEventSourceMappingsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<EventSourceMappingConfiguration>> EVENT_SOURCE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListEventSourceMappingsResponse.getter(ListEventSourceMappingsResponse::eventSourceMappings)).setter(ListEventSourceMappingsResponse.setter(Builder::eventSourceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSourceMappingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, EVENT_SOURCE_MAPPINGS_FIELD));
    private final String nextMarker;
    private final List<EventSourceMappingConfiguration> eventSourceMappings;

    private ListEventSourceMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.eventSourceMappings = builder.eventSourceMappings;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<EventSourceMappingConfiguration> eventSourceMappings() {
        return this.eventSourceMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourceMappingsResponse)) {
            return false;
        }
        ListEventSourceMappingsResponse other = (ListEventSourceMappingsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.eventSourceMappings(), other.eventSourceMappings());
    }

    public String toString() {
        return ToString.builder((String)"ListEventSourceMappingsResponse").add("NextMarker", (Object)this.nextMarker()).add("EventSourceMappings", this.eventSourceMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "EventSourceMappings": {
                return Optional.ofNullable(clazz.cast(this.eventSourceMappings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventSourceMappingsResponse, T> g) {
        return obj -> g.apply((ListEventSourceMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<EventSourceMappingConfiguration> eventSourceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventSourceMappingsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.eventSourceMappings(model.eventSourceMappings);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<EventSourceMappingConfiguration.Builder> getEventSourceMappings() {
            return this.eventSourceMappings != null ? (Collection)this.eventSourceMappings.stream().map(EventSourceMappingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copy(eventSourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSourceMappings(EventSourceMappingConfiguration ... eventSourceMappings) {
            this.eventSourceMappings(Arrays.asList(eventSourceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSourceMappings(Consumer<EventSourceMappingConfiguration.Builder> ... eventSourceMappings) {
            this.eventSourceMappings(Stream.of(eventSourceMappings).map(c -> (EventSourceMappingConfiguration)((EventSourceMappingConfiguration.Builder)EventSourceMappingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventSourceMappings(Collection<EventSourceMappingConfiguration.BuilderImpl> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copyFromBuilder(eventSourceMappings);
        }

        @Override
        public ListEventSourceMappingsResponse build() {
            return new ListEventSourceMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventSourceMappingsResponse> {
        public Builder nextMarker(String var1);

        public Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> var1);

        public Builder eventSourceMappings(EventSourceMappingConfiguration ... var1);

        public Builder eventSourceMappings(Consumer<EventSourceMappingConfiguration.Builder> ... var1);
    }
}

