/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendDurableExecutionCallbackSuccessRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, SendDurableExecutionCallbackSuccessRequest> {
    private static final SdkField<String> CALLBACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallbackId").getter(SendDurableExecutionCallbackSuccessRequest.getter(SendDurableExecutionCallbackSuccessRequest::callbackId)).setter(SendDurableExecutionCallbackSuccessRequest.setter(Builder::callbackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CallbackId").build()}).build();
    private static final SdkField<SdkBytes> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Result").getter(SendDurableExecutionCallbackSuccessRequest.getter(SendDurableExecutionCallbackSuccessRequest::result)).setter(SendDurableExecutionCallbackSuccessRequest.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLBACK_ID_FIELD, RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendDurableExecutionCallbackSuccessRequest.memberNameToFieldInitializer();
    private final String callbackId;
    private final SdkBytes result;

    private SendDurableExecutionCallbackSuccessRequest(BuilderImpl builder) {
        super(builder);
        this.callbackId = builder.callbackId;
        this.result = builder.result;
    }

    public final String callbackId() {
        return this.callbackId;
    }

    public final SdkBytes result() {
        return this.result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDurableExecutionCallbackSuccessRequest)) {
            return false;
        }
        SendDurableExecutionCallbackSuccessRequest other = (SendDurableExecutionCallbackSuccessRequest)((Object)obj);
        return Objects.equals(this.callbackId(), other.callbackId()) && Objects.equals(this.result(), other.result());
    }

    public final String toString() {
        return ToString.builder((String)"SendDurableExecutionCallbackSuccessRequest").add("CallbackId", (Object)this.callbackId()).add("Result", (Object)(this.result() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallbackId": {
                return Optional.ofNullable(clazz.cast(this.callbackId()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CallbackId", CALLBACK_ID_FIELD);
        map.put("Result", RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendDurableExecutionCallbackSuccessRequest, T> g) {
        return obj -> g.apply((SendDurableExecutionCallbackSuccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String callbackId;
        private SdkBytes result;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDurableExecutionCallbackSuccessRequest model) {
            super(model);
            this.callbackId(model.callbackId);
            this.result(model.result);
        }

        public final String getCallbackId() {
            return this.callbackId;
        }

        public final void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @Override
        public final Builder callbackId(String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final ByteBuffer getResult() {
            return this.result == null ? null : this.result.asByteBuffer();
        }

        public final void setResult(ByteBuffer result) {
            this.result(result == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)result));
        }

        @Override
        public final Builder result(SdkBytes result) {
            this.result = result;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDurableExecutionCallbackSuccessRequest build() {
            return new SendDurableExecutionCallbackSuccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendDurableExecutionCallbackSuccessRequest> {
        public Builder callbackId(String var1);

        public Builder result(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

