/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FunctionUrlAuthType {
    NONE("NONE"),
    AWS_IAM("AWS_IAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FunctionUrlAuthType> VALUE_MAP;
    private final String value;

    private FunctionUrlAuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FunctionUrlAuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FunctionUrlAuthType> knownValues() {
        EnumSet<FunctionUrlAuthType> knownValues = EnumSet.allOf(FunctionUrlAuthType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FunctionUrlAuthType.class, FunctionUrlAuthType::toString);
    }
}

