/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFunctionScalingConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<PutFunctionScalingConfigResponse.Builder, PutFunctionScalingConfigResponse> {
    private static final SdkField<String> FUNCTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionState").getter(getter(PutFunctionScalingConfigResponse::functionStateAsString))
            .setter(setter(Builder::functionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String functionState;

    private PutFunctionScalingConfigResponse(BuilderImpl builder) {
        super(builder);
        this.functionState = builder.functionState;
    }

    /**
     * <p>
     * The current state of the function after applying the scaling configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #functionState}
     * will return {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #functionStateAsString}.
     * </p>
     * 
     * @return The current state of the function after applying the scaling configuration.
     * @see State
     */
    public final State functionState() {
        return State.fromValue(functionState);
    }

    /**
     * <p>
     * The current state of the function after applying the scaling configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #functionState}
     * will return {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #functionStateAsString}.
     * </p>
     * 
     * @return The current state of the function after applying the scaling configuration.
     * @see State
     */
    public final String functionStateAsString() {
        return functionState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionScalingConfigResponse)) {
            return false;
        }
        PutFunctionScalingConfigResponse other = (PutFunctionScalingConfigResponse) obj;
        return Objects.equals(functionStateAsString(), other.functionStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFunctionScalingConfigResponse").add("FunctionState", functionStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionState":
            return Optional.ofNullable(clazz.cast(functionStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionState", FUNCTION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionScalingConfigResponse, T> g) {
        return obj -> g.apply((PutFunctionScalingConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutFunctionScalingConfigResponse> {
        /**
         * <p>
         * The current state of the function after applying the scaling configuration.
         * </p>
         * 
         * @param functionState
         *        The current state of the function after applying the scaling configuration.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder functionState(String functionState);

        /**
         * <p>
         * The current state of the function after applying the scaling configuration.
         * </p>
         * 
         * @param functionState
         *        The current state of the function after applying the scaling configuration.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder functionState(State functionState);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String functionState;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionScalingConfigResponse model) {
            super(model);
            functionState(model.functionState);
        }

        public final String getFunctionState() {
            return functionState;
        }

        public final void setFunctionState(String functionState) {
            this.functionState = functionState;
        }

        @Override
        public final Builder functionState(String functionState) {
            this.functionState = functionState;
            return this;
        }

        @Override
        public final Builder functionState(State functionState) {
            this.functionState(functionState == null ? null : functionState.toString());
            return this;
        }

        @Override
        public PutFunctionScalingConfigResponse build() {
            return new PutFunctionScalingConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
