/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for Lambda-managed instances used by the capacity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaManagedInstancesCapacityProviderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaManagedInstancesCapacityProviderConfig.Builder, LambdaManagedInstancesCapacityProviderConfig> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityProviderArn").getter(getter(LambdaManagedInstancesCapacityProviderConfig::capacityProviderArn))
            .setter(setter(Builder::capacityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderArn").build())
            .build();

    private static final SdkField<Integer> PER_EXECUTION_ENVIRONMENT_MAX_CONCURRENCY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerExecutionEnvironmentMaxConcurrency")
            .getter(getter(LambdaManagedInstancesCapacityProviderConfig::perExecutionEnvironmentMaxConcurrency))
            .setter(setter(Builder::perExecutionEnvironmentMaxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PerExecutionEnvironmentMaxConcurrency").build()).build();

    private static final SdkField<Double> EXECUTION_ENVIRONMENT_MEMORY_GI_B_PER_V_CPU_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("ExecutionEnvironmentMemoryGiBPerVCpu")
            .getter(getter(LambdaManagedInstancesCapacityProviderConfig::executionEnvironmentMemoryGiBPerVCpu))
            .setter(setter(Builder::executionEnvironmentMemoryGiBPerVCpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ExecutionEnvironmentMemoryGiBPerVCpu").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD,
            PER_EXECUTION_ENVIRONMENT_MAX_CONCURRENCY_FIELD, EXECUTION_ENVIRONMENT_MEMORY_GI_B_PER_V_CPU_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityProviderArn;

    private final Integer perExecutionEnvironmentMaxConcurrency;

    private final Double executionEnvironmentMemoryGiBPerVCpu;

    private LambdaManagedInstancesCapacityProviderConfig(BuilderImpl builder) {
        this.capacityProviderArn = builder.capacityProviderArn;
        this.perExecutionEnvironmentMaxConcurrency = builder.perExecutionEnvironmentMaxConcurrency;
        this.executionEnvironmentMemoryGiBPerVCpu = builder.executionEnvironmentMemoryGiBPerVCpu;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the capacity provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the capacity provider.
     */
    public final String capacityProviderArn() {
        return capacityProviderArn;
    }

    /**
     * <p>
     * The maximum number of concurrent execution environments that can run on each compute instance.
     * </p>
     * 
     * @return The maximum number of concurrent execution environments that can run on each compute instance.
     */
    public final Integer perExecutionEnvironmentMaxConcurrency() {
        return perExecutionEnvironmentMaxConcurrency;
    }

    /**
     * <p>
     * The amount of memory in GiB allocated per vCPU for execution environments.
     * </p>
     * 
     * @return The amount of memory in GiB allocated per vCPU for execution environments.
     */
    public final Double executionEnvironmentMemoryGiBPerVCpu() {
        return executionEnvironmentMemoryGiBPerVCpu;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(perExecutionEnvironmentMaxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(executionEnvironmentMemoryGiBPerVCpu());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaManagedInstancesCapacityProviderConfig)) {
            return false;
        }
        LambdaManagedInstancesCapacityProviderConfig other = (LambdaManagedInstancesCapacityProviderConfig) obj;
        return Objects.equals(capacityProviderArn(), other.capacityProviderArn())
                && Objects.equals(perExecutionEnvironmentMaxConcurrency(), other.perExecutionEnvironmentMaxConcurrency())
                && Objects.equals(executionEnvironmentMemoryGiBPerVCpu(), other.executionEnvironmentMemoryGiBPerVCpu());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaManagedInstancesCapacityProviderConfig").add("CapacityProviderArn", capacityProviderArn())
                .add("PerExecutionEnvironmentMaxConcurrency", perExecutionEnvironmentMaxConcurrency())
                .add("ExecutionEnvironmentMemoryGiBPerVCpu", executionEnvironmentMemoryGiBPerVCpu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviderArn":
            return Optional.ofNullable(clazz.cast(capacityProviderArn()));
        case "PerExecutionEnvironmentMaxConcurrency":
            return Optional.ofNullable(clazz.cast(perExecutionEnvironmentMaxConcurrency()));
        case "ExecutionEnvironmentMemoryGiBPerVCpu":
            return Optional.ofNullable(clazz.cast(executionEnvironmentMemoryGiBPerVCpu()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityProviderArn", CAPACITY_PROVIDER_ARN_FIELD);
        map.put("PerExecutionEnvironmentMaxConcurrency", PER_EXECUTION_ENVIRONMENT_MAX_CONCURRENCY_FIELD);
        map.put("ExecutionEnvironmentMemoryGiBPerVCpu", EXECUTION_ENVIRONMENT_MEMORY_GI_B_PER_V_CPU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaManagedInstancesCapacityProviderConfig, T> g) {
        return obj -> g.apply((LambdaManagedInstancesCapacityProviderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaManagedInstancesCapacityProviderConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the capacity provider.
         * </p>
         * 
         * @param capacityProviderArn
         *        The Amazon Resource Name (ARN) of the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderArn(String capacityProviderArn);

        /**
         * <p>
         * The maximum number of concurrent execution environments that can run on each compute instance.
         * </p>
         * 
         * @param perExecutionEnvironmentMaxConcurrency
         *        The maximum number of concurrent execution environments that can run on each compute instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perExecutionEnvironmentMaxConcurrency(Integer perExecutionEnvironmentMaxConcurrency);

        /**
         * <p>
         * The amount of memory in GiB allocated per vCPU for execution environments.
         * </p>
         * 
         * @param executionEnvironmentMemoryGiBPerVCpu
         *        The amount of memory in GiB allocated per vCPU for execution environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEnvironmentMemoryGiBPerVCpu(Double executionEnvironmentMemoryGiBPerVCpu);
    }

    static final class BuilderImpl implements Builder {
        private String capacityProviderArn;

        private Integer perExecutionEnvironmentMaxConcurrency;

        private Double executionEnvironmentMemoryGiBPerVCpu;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaManagedInstancesCapacityProviderConfig model) {
            capacityProviderArn(model.capacityProviderArn);
            perExecutionEnvironmentMaxConcurrency(model.perExecutionEnvironmentMaxConcurrency);
            executionEnvironmentMemoryGiBPerVCpu(model.executionEnvironmentMemoryGiBPerVCpu);
        }

        public final String getCapacityProviderArn() {
            return capacityProviderArn;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final Integer getPerExecutionEnvironmentMaxConcurrency() {
            return perExecutionEnvironmentMaxConcurrency;
        }

        public final void setPerExecutionEnvironmentMaxConcurrency(Integer perExecutionEnvironmentMaxConcurrency) {
            this.perExecutionEnvironmentMaxConcurrency = perExecutionEnvironmentMaxConcurrency;
        }

        @Override
        public final Builder perExecutionEnvironmentMaxConcurrency(Integer perExecutionEnvironmentMaxConcurrency) {
            this.perExecutionEnvironmentMaxConcurrency = perExecutionEnvironmentMaxConcurrency;
            return this;
        }

        public final Double getExecutionEnvironmentMemoryGiBPerVCpu() {
            return executionEnvironmentMemoryGiBPerVCpu;
        }

        public final void setExecutionEnvironmentMemoryGiBPerVCpu(Double executionEnvironmentMemoryGiBPerVCpu) {
            this.executionEnvironmentMemoryGiBPerVCpu = executionEnvironmentMemoryGiBPerVCpu;
        }

        @Override
        public final Builder executionEnvironmentMemoryGiBPerVCpu(Double executionEnvironmentMemoryGiBPerVCpu) {
            this.executionEnvironmentMemoryGiBPerVCpu = executionEnvironmentMemoryGiBPerVCpu;
            return this;
        }

        @Override
        public LambdaManagedInstancesCapacityProviderConfig build() {
            return new LambdaManagedInstancesCapacityProviderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
