/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration that defines the scaling behavior for a Lambda Managed Instances function, including the minimum and
 * maximum number of execution environments that can be provisioned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionScalingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionScalingConfig.Builder, FunctionScalingConfig> {
    private static final SdkField<Integer> MIN_EXECUTION_ENVIRONMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinExecutionEnvironments").getter(getter(FunctionScalingConfig::minExecutionEnvironments))
            .setter(setter(Builder::minExecutionEnvironments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinExecutionEnvironments").build())
            .build();

    private static final SdkField<Integer> MAX_EXECUTION_ENVIRONMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxExecutionEnvironments").getter(getter(FunctionScalingConfig::maxExecutionEnvironments))
            .setter(setter(Builder::maxExecutionEnvironments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxExecutionEnvironments").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MIN_EXECUTION_ENVIRONMENTS_FIELD, MAX_EXECUTION_ENVIRONMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minExecutionEnvironments;

    private final Integer maxExecutionEnvironments;

    private FunctionScalingConfig(BuilderImpl builder) {
        this.minExecutionEnvironments = builder.minExecutionEnvironments;
        this.maxExecutionEnvironments = builder.maxExecutionEnvironments;
    }

    /**
     * <p>
     * The minimum number of execution environments to maintain for the function.
     * </p>
     * 
     * @return The minimum number of execution environments to maintain for the function.
     */
    public final Integer minExecutionEnvironments() {
        return minExecutionEnvironments;
    }

    /**
     * <p>
     * The maximum number of execution environments that can be provisioned for the function.
     * </p>
     * 
     * @return The maximum number of execution environments that can be provisioned for the function.
     */
    public final Integer maxExecutionEnvironments() {
        return maxExecutionEnvironments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minExecutionEnvironments());
        hashCode = 31 * hashCode + Objects.hashCode(maxExecutionEnvironments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionScalingConfig)) {
            return false;
        }
        FunctionScalingConfig other = (FunctionScalingConfig) obj;
        return Objects.equals(minExecutionEnvironments(), other.minExecutionEnvironments())
                && Objects.equals(maxExecutionEnvironments(), other.maxExecutionEnvironments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionScalingConfig").add("MinExecutionEnvironments", minExecutionEnvironments())
                .add("MaxExecutionEnvironments", maxExecutionEnvironments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinExecutionEnvironments":
            return Optional.ofNullable(clazz.cast(minExecutionEnvironments()));
        case "MaxExecutionEnvironments":
            return Optional.ofNullable(clazz.cast(maxExecutionEnvironments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinExecutionEnvironments", MIN_EXECUTION_ENVIRONMENTS_FIELD);
        map.put("MaxExecutionEnvironments", MAX_EXECUTION_ENVIRONMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionScalingConfig, T> g) {
        return obj -> g.apply((FunctionScalingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionScalingConfig> {
        /**
         * <p>
         * The minimum number of execution environments to maintain for the function.
         * </p>
         * 
         * @param minExecutionEnvironments
         *        The minimum number of execution environments to maintain for the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minExecutionEnvironments(Integer minExecutionEnvironments);

        /**
         * <p>
         * The maximum number of execution environments that can be provisioned for the function.
         * </p>
         * 
         * @param maxExecutionEnvironments
         *        The maximum number of execution environments that can be provisioned for the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxExecutionEnvironments(Integer maxExecutionEnvironments);
    }

    static final class BuilderImpl implements Builder {
        private Integer minExecutionEnvironments;

        private Integer maxExecutionEnvironments;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionScalingConfig model) {
            minExecutionEnvironments(model.minExecutionEnvironments);
            maxExecutionEnvironments(model.maxExecutionEnvironments);
        }

        public final Integer getMinExecutionEnvironments() {
            return minExecutionEnvironments;
        }

        public final void setMinExecutionEnvironments(Integer minExecutionEnvironments) {
            this.minExecutionEnvironments = minExecutionEnvironments;
        }

        @Override
        public final Builder minExecutionEnvironments(Integer minExecutionEnvironments) {
            this.minExecutionEnvironments = minExecutionEnvironments;
            return this;
        }

        public final Integer getMaxExecutionEnvironments() {
            return maxExecutionEnvironments;
        }

        public final void setMaxExecutionEnvironments(Integer maxExecutionEnvironments) {
            this.maxExecutionEnvironments = maxExecutionEnvironments;
        }

        @Override
        public final Builder maxExecutionEnvironments(Integer maxExecutionEnvironments) {
            this.maxExecutionEnvironments = maxExecutionEnvironments;
            return this;
        }

        @Override
        public FunctionScalingConfig build() {
            return new FunctionScalingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
