/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a durable execution that started.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionStartedDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionStartedDetails.Builder, ExecutionStartedDetails> {
    private static final SdkField<EventInput> INPUT_FIELD = SdkField.<EventInput> builder(MarshallingType.SDK_POJO)
            .memberName("Input").getter(getter(ExecutionStartedDetails::input)).setter(setter(Builder::input))
            .constructor(EventInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<Integer> EXECUTION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionTimeout").getter(getter(ExecutionStartedDetails::executionTimeout))
            .setter(setter(Builder::executionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD,
            EXECUTION_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EventInput input;

    private final Integer executionTimeout;

    private ExecutionStartedDetails(BuilderImpl builder) {
        this.input = builder.input;
        this.executionTimeout = builder.executionTimeout;
    }

    /**
     * <p>
     * The input payload provided for the durable execution.
     * </p>
     * 
     * @return The input payload provided for the durable execution.
     */
    public final EventInput input() {
        return input;
    }

    /**
     * <p>
     * The maximum amount of time that the durable execution is allowed to run, in seconds.
     * </p>
     * 
     * @return The maximum amount of time that the durable execution is allowed to run, in seconds.
     */
    public final Integer executionTimeout() {
        return executionTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStartedDetails)) {
            return false;
        }
        ExecutionStartedDetails other = (ExecutionStartedDetails) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(executionTimeout(), other.executionTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionStartedDetails").add("Input", input()).add("ExecutionTimeout", executionTimeout())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "ExecutionTimeout":
            return Optional.ofNullable(clazz.cast(executionTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Input", INPUT_FIELD);
        map.put("ExecutionTimeout", EXECUTION_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStartedDetails, T> g) {
        return obj -> g.apply((ExecutionStartedDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionStartedDetails> {
        /**
         * <p>
         * The input payload provided for the durable execution.
         * </p>
         * 
         * @param input
         *        The input payload provided for the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(EventInput input);

        /**
         * <p>
         * The input payload provided for the durable execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventInput.Builder} avoiding the need to
         * create one manually via {@link EventInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventInput.Builder#build()} is called immediately and its result
         * is passed to {@link #input(EventInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link EventInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(EventInput)
         */
        default Builder input(Consumer<EventInput.Builder> input) {
            return input(EventInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * The maximum amount of time that the durable execution is allowed to run, in seconds.
         * </p>
         * 
         * @param executionTimeout
         *        The maximum amount of time that the durable execution is allowed to run, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeout(Integer executionTimeout);
    }

    static final class BuilderImpl implements Builder {
        private EventInput input;

        private Integer executionTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStartedDetails model) {
            input(model.input);
            executionTimeout(model.executionTimeout);
        }

        public final EventInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(EventInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(EventInput input) {
            this.input = input;
            return this;
        }

        public final Integer getExecutionTimeout() {
            return executionTimeout;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        @Override
        public ExecutionStartedDetails build() {
            return new ExecutionStartedDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
