/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a failed <a href="https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html">durable
 * execution</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionFailedDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionFailedDetails.Builder, ExecutionFailedDetails> {
    private static final SdkField<EventError> ERROR_FIELD = SdkField.<EventError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(ExecutionFailedDetails::error)).setter(setter(Builder::error))
            .constructor(EventError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EventError error;

    private ExecutionFailedDetails(BuilderImpl builder) {
        this.error = builder.error;
    }

    /**
     * <p>
     * Details about the execution failure.
     * </p>
     * 
     * @return Details about the execution failure.
     */
    public final EventError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionFailedDetails)) {
            return false;
        }
        ExecutionFailedDetails other = (ExecutionFailedDetails) obj;
        return Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionFailedDetails").add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionFailedDetails, T> g) {
        return obj -> g.apply((ExecutionFailedDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionFailedDetails> {
        /**
         * <p>
         * Details about the execution failure.
         * </p>
         * 
         * @param error
         *        Details about the execution failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(EventError error);

        /**
         * <p>
         * Details about the execution failure.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventError.Builder} avoiding the need to
         * create one manually via {@link EventError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventError.Builder#build()} is called immediately and its result
         * is passed to {@link #error(EventError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link EventError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(EventError)
         */
        default Builder error(Consumer<EventError.Builder> error) {
            return error(EventError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EventError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionFailedDetails model) {
            error(model.error);
        }

        public final EventError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(EventError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(EventError error) {
            this.error = error;
            return this;
        }

        @Override
        public ExecutionFailedDetails build() {
            return new ExecutionFailedDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
