/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metrics configuration for your event source. Use this configuration object to define which metrics you want your
 * event source mapping to produce.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSourceMappingMetricsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EventSourceMappingMetricsConfig.Builder, EventSourceMappingMetricsConfig> {
    private static final SdkField<List<String>> METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(EventSourceMappingMetricsConfig::metricsAsStrings))
            .setter(setter(Builder::metricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> metrics;

    private EventSourceMappingMetricsConfig(BuilderImpl builder) {
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * The metrics you want your event source mapping to produce, including <code>EventCount</code>,
     * <code>ErrorCount</code>, <code>KafkaMetrics</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EventCount</code> to receive metrics related to the number of events processed by your event source
     * mapping.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the number of
     * errors in your event source mapping processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the Kafka
     * consumers from your event source mapping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about these metrics, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics">
     * Event source mapping metrics</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics you want your event source mapping to produce, including <code>EventCount</code>,
     *         <code>ErrorCount</code>, <code>KafkaMetrics</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EventCount</code> to receive metrics related to the number of events processed by your event source
     *         mapping.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
     *         number of errors in your event source mapping processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
     *         Kafka consumers from your event source mapping.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about these metrics, see <a href=
     *         "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
     *         > Event source mapping metrics</a>.
     */
    public final List<EventSourceMappingMetric> metrics() {
        return EventSourceMappingMetricListCopier.copyStringToEnum(metrics);
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics you want your event source mapping to produce, including <code>EventCount</code>,
     * <code>ErrorCount</code>, <code>KafkaMetrics</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EventCount</code> to receive metrics related to the number of events processed by your event source
     * mapping.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the number of
     * errors in your event source mapping processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the Kafka
     * consumers from your event source mapping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about these metrics, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics">
     * Event source mapping metrics</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics you want your event source mapping to produce, including <code>EventCount</code>,
     *         <code>ErrorCount</code>, <code>KafkaMetrics</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EventCount</code> to receive metrics related to the number of events processed by your event source
     *         mapping.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
     *         number of errors in your event source mapping processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
     *         Kafka consumers from your event source mapping.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about these metrics, see <a href=
     *         "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
     *         > Event source mapping metrics</a>.
     */
    public final List<String> metricsAsStrings() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metricsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSourceMappingMetricsConfig)) {
            return false;
        }
        EventSourceMappingMetricsConfig other = (EventSourceMappingMetricsConfig) obj;
        return hasMetrics() == other.hasMetrics() && Objects.equals(metricsAsStrings(), other.metricsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventSourceMappingMetricsConfig").add("Metrics", hasMetrics() ? metricsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metricsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventSourceMappingMetricsConfig, T> g) {
        return obj -> g.apply((EventSourceMappingMetricsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSourceMappingMetricsConfig> {
        /**
         * <p>
         * The metrics you want your event source mapping to produce, including <code>EventCount</code>,
         * <code>ErrorCount</code>, <code>KafkaMetrics</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EventCount</code> to receive metrics related to the number of events processed by your event source
         * mapping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the number
         * of errors in your event source mapping processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the Kafka
         * consumers from your event source mapping.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about these metrics, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics">
         * Event source mapping metrics</a>.
         * </p>
         * 
         * @param metrics
         *        The metrics you want your event source mapping to produce, including <code>EventCount</code>,
         *        <code>ErrorCount</code>, <code>KafkaMetrics</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EventCount</code> to receive metrics related to the number of events processed by your event
         *        source mapping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
         *        number of errors in your event source mapping processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
         *        Kafka consumers from your event source mapping.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about these metrics, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         *        > Event source mapping metrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsWithStrings(Collection<String> metrics);

        /**
         * <p>
         * The metrics you want your event source mapping to produce, including <code>EventCount</code>,
         * <code>ErrorCount</code>, <code>KafkaMetrics</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EventCount</code> to receive metrics related to the number of events processed by your event source
         * mapping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the number
         * of errors in your event source mapping processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the Kafka
         * consumers from your event source mapping.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about these metrics, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics">
         * Event source mapping metrics</a>.
         * </p>
         * 
         * @param metrics
         *        The metrics you want your event source mapping to produce, including <code>EventCount</code>,
         *        <code>ErrorCount</code>, <code>KafkaMetrics</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EventCount</code> to receive metrics related to the number of events processed by your event
         *        source mapping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
         *        number of errors in your event source mapping processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
         *        Kafka consumers from your event source mapping.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about these metrics, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         *        > Event source mapping metrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsWithStrings(String... metrics);

        /**
         * <p>
         * The metrics you want your event source mapping to produce, including <code>EventCount</code>,
         * <code>ErrorCount</code>, <code>KafkaMetrics</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EventCount</code> to receive metrics related to the number of events processed by your event source
         * mapping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the number
         * of errors in your event source mapping processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the Kafka
         * consumers from your event source mapping.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about these metrics, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics">
         * Event source mapping metrics</a>.
         * </p>
         * 
         * @param metrics
         *        The metrics you want your event source mapping to produce, including <code>EventCount</code>,
         *        <code>ErrorCount</code>, <code>KafkaMetrics</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EventCount</code> to receive metrics related to the number of events processed by your event
         *        source mapping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
         *        number of errors in your event source mapping processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
         *        Kafka consumers from your event source mapping.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about these metrics, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         *        > Event source mapping metrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<EventSourceMappingMetric> metrics);

        /**
         * <p>
         * The metrics you want your event source mapping to produce, including <code>EventCount</code>,
         * <code>ErrorCount</code>, <code>KafkaMetrics</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EventCount</code> to receive metrics related to the number of events processed by your event source
         * mapping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the number
         * of errors in your event source mapping processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the Kafka
         * consumers from your event source mapping.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about these metrics, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics">
         * Event source mapping metrics</a>.
         * </p>
         * 
         * @param metrics
         *        The metrics you want your event source mapping to produce, including <code>EventCount</code>,
         *        <code>ErrorCount</code>, <code>KafkaMetrics</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EventCount</code> to receive metrics related to the number of events processed by your event
         *        source mapping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ErrorCount</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
         *        number of errors in your event source mapping processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KafkaMetrics</code> (Amazon MSK and self-managed Apache Kafka) to receive metrics related to the
         *        Kafka consumers from your event source mapping.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about these metrics, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         *        > Event source mapping metrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(EventSourceMappingMetric... metrics);
    }

    static final class BuilderImpl implements Builder {
        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventSourceMappingMetricsConfig model) {
            metricsWithStrings(model.metrics);
        }

        public final Collection<String> getMetrics() {
            if (metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = EventSourceMappingMetricListCopier.copy(metrics);
        }

        @Override
        public final Builder metricsWithStrings(Collection<String> metrics) {
            this.metrics = EventSourceMappingMetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsWithStrings(String... metrics) {
            metricsWithStrings(Arrays.asList(metrics));
            return this;
        }

        @Override
        public final Builder metrics(Collection<EventSourceMappingMetric> metrics) {
            this.metrics = EventSourceMappingMetricListCopier.copyEnumToString(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(EventSourceMappingMetric... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        public EventSourceMappingMetricsConfig build() {
            return new EventSourceMappingMetricsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
