/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.CheckpointUpdatedExecutionState;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckpointDurableExecutionResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, CheckpointDurableExecutionResponse> {
    private static final SdkField<String> CHECKPOINT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CheckpointToken").getter(CheckpointDurableExecutionResponse.getter(CheckpointDurableExecutionResponse::checkpointToken)).setter(CheckpointDurableExecutionResponse.setter(Builder::checkpointToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointToken").build()}).build();
    private static final SdkField<CheckpointUpdatedExecutionState> NEW_EXECUTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewExecutionState").getter(CheckpointDurableExecutionResponse.getter(CheckpointDurableExecutionResponse::newExecutionState)).setter(CheckpointDurableExecutionResponse.setter(Builder::newExecutionState)).constructor(CheckpointUpdatedExecutionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewExecutionState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKPOINT_TOKEN_FIELD, NEW_EXECUTION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckpointDurableExecutionResponse.memberNameToFieldInitializer();
    private final String checkpointToken;
    private final CheckpointUpdatedExecutionState newExecutionState;

    private CheckpointDurableExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.checkpointToken = builder.checkpointToken;
        this.newExecutionState = builder.newExecutionState;
    }

    public final String checkpointToken() {
        return this.checkpointToken;
    }

    public final CheckpointUpdatedExecutionState newExecutionState() {
        return this.newExecutionState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.newExecutionState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointDurableExecutionResponse)) {
            return false;
        }
        CheckpointDurableExecutionResponse other = (CheckpointDurableExecutionResponse)((Object)obj);
        return Objects.equals(this.checkpointToken(), other.checkpointToken()) && Objects.equals(this.newExecutionState(), other.newExecutionState());
    }

    public final String toString() {
        return ToString.builder((String)"CheckpointDurableExecutionResponse").add("CheckpointToken", (Object)this.checkpointToken()).add("NewExecutionState", (Object)this.newExecutionState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CheckpointToken": {
                return Optional.ofNullable(clazz.cast(this.checkpointToken()));
            }
            case "NewExecutionState": {
                return Optional.ofNullable(clazz.cast(this.newExecutionState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CheckpointToken", CHECKPOINT_TOKEN_FIELD);
        map.put("NewExecutionState", NEW_EXECUTION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckpointDurableExecutionResponse, T> g) {
        return obj -> g.apply((CheckpointDurableExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String checkpointToken;
        private CheckpointUpdatedExecutionState newExecutionState;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointDurableExecutionResponse model) {
            super(model);
            this.checkpointToken(model.checkpointToken);
            this.newExecutionState(model.newExecutionState);
        }

        public final String getCheckpointToken() {
            return this.checkpointToken;
        }

        public final void setCheckpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
        }

        @Override
        public final Builder checkpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
            return this;
        }

        public final CheckpointUpdatedExecutionState.Builder getNewExecutionState() {
            return this.newExecutionState != null ? this.newExecutionState.toBuilder() : null;
        }

        public final void setNewExecutionState(CheckpointUpdatedExecutionState.BuilderImpl newExecutionState) {
            this.newExecutionState = newExecutionState != null ? newExecutionState.build() : null;
        }

        @Override
        public final Builder newExecutionState(CheckpointUpdatedExecutionState newExecutionState) {
            this.newExecutionState = newExecutionState;
            return this;
        }

        @Override
        public CheckpointDurableExecutionResponse build() {
            return new CheckpointDurableExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckpointDurableExecutionResponse> {
        public Builder checkpointToken(String var1);

        public Builder newExecutionState(CheckpointUpdatedExecutionState var1);

        default public Builder newExecutionState(Consumer<CheckpointUpdatedExecutionState.Builder> newExecutionState) {
            return this.newExecutionState((CheckpointUpdatedExecutionState)((CheckpointUpdatedExecutionState.Builder)CheckpointUpdatedExecutionState.builder().applyMutation(newExecutionState)).build());
        }
    }
}

