/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.Execution;
import software.amazon.awssdk.services.lambda.model.ListDurableExecutionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListDurableExecutionsByFunctionResponse;

public class ListDurableExecutionsByFunctionPublisher
implements SdkPublisher<ListDurableExecutionsByFunctionResponse> {
    private final LambdaAsyncClient client;
    private final ListDurableExecutionsByFunctionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDurableExecutionsByFunctionPublisher(LambdaAsyncClient client, ListDurableExecutionsByFunctionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDurableExecutionsByFunctionPublisher(LambdaAsyncClient client, ListDurableExecutionsByFunctionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDurableExecutionsByFunctionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDurableExecutionsByFunctionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Execution> durableExecutions() {
        return this.flatMapIterable(response -> response.durableExecutions());
    }

    private class ListDurableExecutionsByFunctionResponseFetcher
    implements AsyncPageFetcher<ListDurableExecutionsByFunctionResponse> {
        private ListDurableExecutionsByFunctionResponseFetcher() {
        }

        public boolean hasNextPage(ListDurableExecutionsByFunctionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListDurableExecutionsByFunctionResponse> nextPage(ListDurableExecutionsByFunctionResponse previousPage) {
            if (previousPage == null) {
                return ListDurableExecutionsByFunctionPublisher.this.client.listDurableExecutionsByFunction(ListDurableExecutionsByFunctionPublisher.this.firstRequest);
            }
            return ListDurableExecutionsByFunctionPublisher.this.client.listDurableExecutionsByFunction((ListDurableExecutionsByFunctionRequest)((Object)ListDurableExecutionsByFunctionPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

