/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem;

public class ListProvisionedConcurrencyConfigsIterable
implements SdkIterable<ListProvisionedConcurrencyConfigsResponse> {
    private final LambdaClient client;
    private final ListProvisionedConcurrencyConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProvisionedConcurrencyConfigsIterable(LambdaClient client, ListProvisionedConcurrencyConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProvisionedConcurrencyConfigsResponseFetcher();
    }

    public Iterator<ListProvisionedConcurrencyConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs() {
        Function<ListProvisionedConcurrencyConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedConcurrencyConfigs() != null) {
                return response.provisionedConcurrencyConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProvisionedConcurrencyConfigsResponseFetcher
    implements SyncPageFetcher<ListProvisionedConcurrencyConfigsResponse> {
        private ListProvisionedConcurrencyConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisionedConcurrencyConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListProvisionedConcurrencyConfigsResponse nextPage(ListProvisionedConcurrencyConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListProvisionedConcurrencyConfigsIterable.this.client.listProvisionedConcurrencyConfigs(ListProvisionedConcurrencyConfigsIterable.this.firstRequest);
            }
            return ListProvisionedConcurrencyConfigsIterable.this.client.listProvisionedConcurrencyConfigs((ListProvisionedConcurrencyConfigsRequest)((Object)ListProvisionedConcurrencyConfigsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

