/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.FunctionVersionsByCapacityProviderListItem;
import software.amazon.awssdk.services.lambda.model.ListFunctionVersionsByCapacityProviderRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionVersionsByCapacityProviderResponse;

public class ListFunctionVersionsByCapacityProviderPublisher
implements SdkPublisher<ListFunctionVersionsByCapacityProviderResponse> {
    private final LambdaAsyncClient client;
    private final ListFunctionVersionsByCapacityProviderRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFunctionVersionsByCapacityProviderPublisher(LambdaAsyncClient client, ListFunctionVersionsByCapacityProviderRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFunctionVersionsByCapacityProviderPublisher(LambdaAsyncClient client, ListFunctionVersionsByCapacityProviderRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFunctionVersionsByCapacityProviderResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFunctionVersionsByCapacityProviderResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FunctionVersionsByCapacityProviderListItem> functionVersions() {
        return this.flatMapIterable(response -> response.functionVersions());
    }

    private class ListFunctionVersionsByCapacityProviderResponseFetcher
    implements AsyncPageFetcher<ListFunctionVersionsByCapacityProviderResponse> {
        private ListFunctionVersionsByCapacityProviderResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionVersionsByCapacityProviderResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListFunctionVersionsByCapacityProviderResponse> nextPage(ListFunctionVersionsByCapacityProviderResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionVersionsByCapacityProviderPublisher.this.client.listFunctionVersionsByCapacityProvider(ListFunctionVersionsByCapacityProviderPublisher.this.firstRequest);
            }
            return ListFunctionVersionsByCapacityProviderPublisher.this.client.listFunctionVersionsByCapacityProvider((ListFunctionVersionsByCapacityProviderRequest)((Object)ListFunctionVersionsByCapacityProviderPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

