/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFunctionVersionsByCapacityProviderRequest extends LambdaRequest implements
        ToCopyableBuilder<ListFunctionVersionsByCapacityProviderRequest.Builder, ListFunctionVersionsByCapacityProviderRequest> {
    private static final SdkField<String> CAPACITY_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityProviderName")
            .getter(getter(ListFunctionVersionsByCapacityProviderRequest::capacityProviderName))
            .setter(setter(Builder::capacityProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CapacityProviderName").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListFunctionVersionsByCapacityProviderRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(ListFunctionVersionsByCapacityProviderRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_NAME_FIELD,
            MARKER_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String capacityProviderName;

    private final String marker;

    private final Integer maxItems;

    private ListFunctionVersionsByCapacityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.capacityProviderName = builder.capacityProviderName;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The name of the capacity provider to list function versions for.
     * </p>
     * 
     * @return The name of the capacity provider to list function versions for.
     */
    public final String capacityProviderName() {
        return capacityProviderName;
    }

    /**
     * <p>
     * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of function versions to return in the response.
     * </p>
     * 
     * @return The maximum number of function versions to return in the response.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionVersionsByCapacityProviderRequest)) {
            return false;
        }
        ListFunctionVersionsByCapacityProviderRequest other = (ListFunctionVersionsByCapacityProviderRequest) obj;
        return Objects.equals(capacityProviderName(), other.capacityProviderName()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFunctionVersionsByCapacityProviderRequest")
                .add("CapacityProviderName", capacityProviderName()).add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviderName":
            return Optional.ofNullable(clazz.cast(capacityProviderName()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityProviderName", CAPACITY_PROVIDER_NAME_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionVersionsByCapacityProviderRequest, T> g) {
        return obj -> g.apply((ListFunctionVersionsByCapacityProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFunctionVersionsByCapacityProviderRequest> {
        /**
         * <p>
         * The name of the capacity provider to list function versions for.
         * </p>
         * 
         * @param capacityProviderName
         *        The name of the capacity provider to list function versions for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderName(String capacityProviderName);

        /**
         * <p>
         * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param marker
         *        Specify the pagination token that's returned by a previous request to retrieve the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of function versions to return in the response.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of function versions to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String capacityProviderName;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionVersionsByCapacityProviderRequest model) {
            super(model);
            capacityProviderName(model.capacityProviderName);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getCapacityProviderName() {
            return capacityProviderName;
        }

        public final void setCapacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
        }

        @Override
        public final Builder capacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFunctionVersionsByCapacityProviderRequest build() {
            return new ListFunctionVersionsByCapacityProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
