/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * (Amazon MSK, and self-managed Apache Kafka only) The logging configuration for your event source. Use this
 * configuration object to define the level of logs for your event source mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSourceMappingLoggingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EventSourceMappingLoggingConfig.Builder, EventSourceMappingLoggingConfig> {
    private static final SdkField<String> SYSTEM_LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SystemLogLevel").getter(getter(EventSourceMappingLoggingConfig::systemLogLevelAsString))
            .setter(setter(Builder::systemLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemLogLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_LOG_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String systemLogLevel;

    private EventSourceMappingLoggingConfig(BuilderImpl builder) {
        this.systemLogLevel = builder.systemLogLevel;
    }

    /**
     * <p>
     * The log level you want your event source mapping to use. Lambda event poller only sends system logs at the
     * selected level of detail and lower, where <code>DEBUG</code> is the highest level and <code>WARN</code> is the
     * lowest. For more information about these metrics, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/esm-logging.html"> Event source mapping logging</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #systemLogLevel}
     * will return {@link EventSourceMappingSystemLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #systemLogLevelAsString}.
     * </p>
     * 
     * @return The log level you want your event source mapping to use. Lambda event poller only sends system logs at
     *         the selected level of detail and lower, where <code>DEBUG</code> is the highest level and
     *         <code>WARN</code> is the lowest. For more information about these metrics, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/esm-logging.html"> Event source mapping logging</a>.
     * @see EventSourceMappingSystemLogLevel
     */
    public final EventSourceMappingSystemLogLevel systemLogLevel() {
        return EventSourceMappingSystemLogLevel.fromValue(systemLogLevel);
    }

    /**
     * <p>
     * The log level you want your event source mapping to use. Lambda event poller only sends system logs at the
     * selected level of detail and lower, where <code>DEBUG</code> is the highest level and <code>WARN</code> is the
     * lowest. For more information about these metrics, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/esm-logging.html"> Event source mapping logging</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #systemLogLevel}
     * will return {@link EventSourceMappingSystemLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #systemLogLevelAsString}.
     * </p>
     * 
     * @return The log level you want your event source mapping to use. Lambda event poller only sends system logs at
     *         the selected level of detail and lower, where <code>DEBUG</code> is the highest level and
     *         <code>WARN</code> is the lowest. For more information about these metrics, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/esm-logging.html"> Event source mapping logging</a>.
     * @see EventSourceMappingSystemLogLevel
     */
    public final String systemLogLevelAsString() {
        return systemLogLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(systemLogLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSourceMappingLoggingConfig)) {
            return false;
        }
        EventSourceMappingLoggingConfig other = (EventSourceMappingLoggingConfig) obj;
        return Objects.equals(systemLogLevelAsString(), other.systemLogLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventSourceMappingLoggingConfig").add("SystemLogLevel", systemLogLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SystemLogLevel":
            return Optional.ofNullable(clazz.cast(systemLogLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SystemLogLevel", SYSTEM_LOG_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventSourceMappingLoggingConfig, T> g) {
        return obj -> g.apply((EventSourceMappingLoggingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSourceMappingLoggingConfig> {
        /**
         * <p>
         * The log level you want your event source mapping to use. Lambda event poller only sends system logs at the
         * selected level of detail and lower, where <code>DEBUG</code> is the highest level and <code>WARN</code> is
         * the lowest. For more information about these metrics, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/esm-logging.html"> Event source mapping logging</a>.
         * </p>
         * 
         * @param systemLogLevel
         *        The log level you want your event source mapping to use. Lambda event poller only sends system logs at
         *        the selected level of detail and lower, where <code>DEBUG</code> is the highest level and
         *        <code>WARN</code> is the lowest. For more information about these metrics, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/esm-logging.html"> Event source mapping
         *        logging</a>.
         * @see EventSourceMappingSystemLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceMappingSystemLogLevel
         */
        Builder systemLogLevel(String systemLogLevel);

        /**
         * <p>
         * The log level you want your event source mapping to use. Lambda event poller only sends system logs at the
         * selected level of detail and lower, where <code>DEBUG</code> is the highest level and <code>WARN</code> is
         * the lowest. For more information about these metrics, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/esm-logging.html"> Event source mapping logging</a>.
         * </p>
         * 
         * @param systemLogLevel
         *        The log level you want your event source mapping to use. Lambda event poller only sends system logs at
         *        the selected level of detail and lower, where <code>DEBUG</code> is the highest level and
         *        <code>WARN</code> is the lowest. For more information about these metrics, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/esm-logging.html"> Event source mapping
         *        logging</a>.
         * @see EventSourceMappingSystemLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceMappingSystemLogLevel
         */
        Builder systemLogLevel(EventSourceMappingSystemLogLevel systemLogLevel);
    }

    static final class BuilderImpl implements Builder {
        private String systemLogLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSourceMappingLoggingConfig model) {
            systemLogLevel(model.systemLogLevel);
        }

        public final String getSystemLogLevel() {
            return systemLogLevel;
        }

        public final void setSystemLogLevel(String systemLogLevel) {
            this.systemLogLevel = systemLogLevel;
        }

        @Override
        public final Builder systemLogLevel(String systemLogLevel) {
            this.systemLogLevel = systemLogLevel;
            return this;
        }

        @Override
        public final Builder systemLogLevel(EventSourceMappingSystemLogLevel systemLogLevel) {
            this.systemLogLevel(systemLogLevel == null ? null : systemLogLevel.toString());
            return this;
        }

        @Override
        public EventSourceMappingLoggingConfig build() {
            return new EventSourceMappingLoggingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
