/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemovePermissionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, RemovePermissionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(RemovePermissionRequest.getter(RemovePermissionRequest::functionName)).setter(RemovePermissionRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementId").getter(RemovePermissionRequest.getter(RemovePermissionRequest::statementId)).setter(RemovePermissionRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("StatementId").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qualifier").getter(RemovePermissionRequest.getter(RemovePermissionRequest::qualifier)).setter(RemovePermissionRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(RemovePermissionRequest.getter(RemovePermissionRequest::revisionId)).setter(RemovePermissionRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, STATEMENT_ID_FIELD, QUALIFIER_FIELD, REVISION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemovePermissionRequest.memberNameToFieldInitializer();
    private final String functionName;
    private final String statementId;
    private final String qualifier;
    private final String revisionId;

    private RemovePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.statementId = builder.statementId;
        this.qualifier = builder.qualifier;
        this.revisionId = builder.revisionId;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String statementId() {
        return this.statementId;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.statementId(), other.statementId()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"RemovePermissionRequest").add("FunctionName", (Object)this.functionName()).add("StatementId", (Object)this.statementId()).add("Qualifier", (Object)this.qualifier()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "StatementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("StatementId", STATEMENT_ID_FIELD);
        map.put("Qualifier", QUALIFIER_FIELD);
        map.put("RevisionId", REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemovePermissionRequest, T> g) {
        return obj -> g.apply((RemovePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String statementId;
        private String qualifier;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.statementId(model.statementId);
            this.qualifier(model.qualifier);
            this.revisionId(model.revisionId);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemovePermissionRequest> {
        public Builder functionName(String var1);

        public Builder statementId(String var1);

        public Builder qualifier(String var1);

        public Builder revisionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

