/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.GetDurableExecutionStateRequest;
import software.amazon.awssdk.services.lambda.model.GetDurableExecutionStateResponse;
import software.amazon.awssdk.services.lambda.model.Operation;

public class GetDurableExecutionStatePublisher
implements SdkPublisher<GetDurableExecutionStateResponse> {
    private final LambdaAsyncClient client;
    private final GetDurableExecutionStateRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDurableExecutionStatePublisher(LambdaAsyncClient client, GetDurableExecutionStateRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDurableExecutionStatePublisher(LambdaAsyncClient client, GetDurableExecutionStateRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDurableExecutionStateResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDurableExecutionStateResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Operation> operations() {
        Function<GetDurableExecutionStateResponse, Iterator> getIterator = response -> {
            if (response != null && response.operations() != null) {
                return response.operations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetDurableExecutionStateResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetDurableExecutionStateResponseFetcher
    implements AsyncPageFetcher<GetDurableExecutionStateResponse> {
        private GetDurableExecutionStateResponseFetcher() {
        }

        public boolean hasNextPage(GetDurableExecutionStateResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<GetDurableExecutionStateResponse> nextPage(GetDurableExecutionStateResponse previousPage) {
            if (previousPage == null) {
                return GetDurableExecutionStatePublisher.this.client.getDurableExecutionState(GetDurableExecutionStatePublisher.this.firstRequest);
            }
            return GetDurableExecutionStatePublisher.this.client.getDurableExecutionState((GetDurableExecutionStateRequest)((Object)GetDurableExecutionStatePublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

