/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a wait operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaitDetails implements SdkPojo, Serializable, ToCopyableBuilder<WaitDetails.Builder, WaitDetails> {
    private static final SdkField<Instant> SCHEDULED_END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledEndTimestamp").getter(getter(WaitDetails::scheduledEndTimestamp))
            .setter(setter(Builder::scheduledEndTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledEndTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SCHEDULED_END_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant scheduledEndTimestamp;

    private WaitDetails(BuilderImpl builder) {
        this.scheduledEndTimestamp = builder.scheduledEndTimestamp;
    }

    /**
     * <p>
     * The date and time when the wait operation is scheduled to complete, in <a
     * href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time when the wait operation is scheduled to complete, in <a
     *         href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant scheduledEndTimestamp() {
        return scheduledEndTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEndTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaitDetails)) {
            return false;
        }
        WaitDetails other = (WaitDetails) obj;
        return Objects.equals(scheduledEndTimestamp(), other.scheduledEndTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaitDetails").add("ScheduledEndTimestamp", scheduledEndTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledEndTimestamp":
            return Optional.ofNullable(clazz.cast(scheduledEndTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduledEndTimestamp", SCHEDULED_END_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaitDetails, T> g) {
        return obj -> g.apply((WaitDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaitDetails> {
        /**
         * <p>
         * The date and time when the wait operation is scheduled to complete, in <a
         * href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param scheduledEndTimestamp
         *        The date and time when the wait operation is scheduled to complete, in <a
         *        href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEndTimestamp(Instant scheduledEndTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Instant scheduledEndTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(WaitDetails model) {
            scheduledEndTimestamp(model.scheduledEndTimestamp);
        }

        public final Instant getScheduledEndTimestamp() {
            return scheduledEndTimestamp;
        }

        public final void setScheduledEndTimestamp(Instant scheduledEndTimestamp) {
            this.scheduledEndTimestamp = scheduledEndTimestamp;
        }

        @Override
        public final Builder scheduledEndTimestamp(Instant scheduledEndTimestamp) {
            this.scheduledEndTimestamp = scheduledEndTimestamp;
            return this;
        }

        @Override
        public WaitDetails build() {
            return new WaitDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
