/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDurableExecutionResponse extends LambdaResponse implements
        ToCopyableBuilder<StopDurableExecutionResponse.Builder, StopDurableExecutionResponse> {
    private static final SdkField<Instant> STOP_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StopTimestamp").getter(getter(StopDurableExecutionResponse::stopTimestamp))
            .setter(setter(Builder::stopTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOP_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant stopTimestamp;

    private StopDurableExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.stopTimestamp = builder.stopTimestamp;
    }

    /**
     * <p>
     * The timestamp when the execution was stopped (ISO 8601 format).
     * </p>
     * 
     * @return The timestamp when the execution was stopped (ISO 8601 format).
     */
    public final Instant stopTimestamp() {
        return stopTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stopTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDurableExecutionResponse)) {
            return false;
        }
        StopDurableExecutionResponse other = (StopDurableExecutionResponse) obj;
        return Objects.equals(stopTimestamp(), other.stopTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopDurableExecutionResponse").add("StopTimestamp", stopTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StopTimestamp":
            return Optional.ofNullable(clazz.cast(stopTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StopTimestamp", STOP_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopDurableExecutionResponse, T> g) {
        return obj -> g.apply((StopDurableExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopDurableExecutionResponse> {
        /**
         * <p>
         * The timestamp when the execution was stopped (ISO 8601 format).
         * </p>
         * 
         * @param stopTimestamp
         *        The timestamp when the execution was stopped (ISO 8601 format).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTimestamp(Instant stopTimestamp);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private Instant stopTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDurableExecutionResponse model) {
            super(model);
            stopTimestamp(model.stopTimestamp);
        }

        public final Instant getStopTimestamp() {
            return stopTimestamp;
        }

        public final void setStopTimestamp(Instant stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
        }

        @Override
        public final Builder stopTimestamp(Instant stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
            return this;
        }

        @Override
        public StopDurableExecutionResponse build() {
            return new StopDurableExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
